/**
 * Sample React Native App
 * https://github.com/facebook/react-native
 *
 * @format
 * @flow strict-local
 */

import React, { useState } from 'react';
import {
  NativeModules,
  NativeEventEmitter,
  SafeAreaView,
  StyleSheet,
  ScrollView,
  View,
  Text,
  Button,
  StatusBar,
  Alert,
  Image,
  TextInput,
  DeviceEventEmitter,
} from 'react-native';
import { BMCUI } from './ui.js'
import CustomerView from './CustomerView.js'
import CustomRoundImageView from './RoundedImage.js'
import MapView from './MapView.js'

import {
  Header,
  LearnMoreLinks,
  Colors,
  DebugInstructions,
  ReloadInstructions,
} from 'react-native/Libraries/NewAppScreen';

var ToastManager = NativeModules.ToastManager;
var AlertManager = NativeModules.AlertManager;

async function showConfirmVsCancelPromiseDialog(msg, leftTip, rightTip) {
  try {
    const {
      right,
      left
    } = await BMCUI.showConfirmVsCancelPromiseDialog(msg, leftTip, rightTip);

    console.log(
      "你点击了按钮，结果为：" + left + " / " + right
    );
  } catch (e) {
    console.error(e);
  }
}

// class App extends React.Component {
//   onRegionChange(event) {
//     console.log(event.region.latitude)
//   }

//   render() {
//     const region = {
//       latitude: 37.48,
//       longitue: -122.16,
//       latitudeDelta: 0.1,
//       longitudeDelta: 0.1,
//     };
//     return (
//       <MapView
//         region={region}
//         zoomEnabled={false}
//         onRegionChange={this.onRegionChange}
//         style={{ flex: 1 }}
//       />
//     );
//   }
// }

const App = () => {
  var index = 0;
  const region = {
    latitude: 37.48,
    longitue: -122.16,
    latitudeDelta: 0.1,
    longitudeDelta: 0.1,
  };
  return (
    <>
      <StatusBar barStyle="dark-content" />
      <SafeAreaView>
         <ScrollView
          contentInsetAdjustmentBehavior="automatic"
          style={styles.scrollView}>
          {global.HermesInternal == null ? null : (
            <View style={styles.engine}>
              <Text style={styles.footer}>Engine: Hermes(need config!!!!)</Text>
            </View>
          )}
          <View style={styles.buttonContainer}>
            <CustomerView style={{height: 80}}/>
            <MapView region={region} zoomEnabled={false} style={{ flex: 1, height: 200}} />
          </View>
          <View style={styles.body}>
            <View style={styles.buttonContainer}>
              {Platform.OS == 'android' ? (
                <CustomRoundImageView src="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1598436038838&di=d725130cf6ca00e920ad68b21ba72f5c&imgtype=0&src=http%3A%2F%2Ft9.baidu.com%2Fit%2Fu%3D1307125826%2C3433407105%26fm%3D79%26app%3D86%26f%3DJPEG%3Fw%3D5760%26h%3D3240"
                  cornerRadius={30} borderWidth={2} style={{ width: 200, height: 160 }} />
              ) : null
              }
              <Button
                style={styles.buttonStyle}
                onPress={() => {
                  index++;
                  DeviceEventEmitter.emit('msg', '发送了个通知:' + index);
                }}
                title="发送消息"
              />
            </View>
            <View style={styles.buttonContainer}>
              <Button
                style={styles.buttonStyle}
                onPress={() => {
                  if (Platform.OS == 'android') {

                    // BMCUI.show('"你点击了按钮！");\
                    console.log(NativeModules);
                    NativeModules.BMCUI.show("你点击了按钮111！");
                    // NativeModules.BMCUI.showWithDuration("你点击了按钮！", NativeModules.BMCUI.SHORT);
                    // Alert.alert("你点击了按钮");
                  } else {
                    // Alert.alert("ios undefine");
                    // NativeModules.ToastManager
                    var alerts = "alert..." + NativeModules.AlertManager.alertStyleLight;
                    console.log(alerts)
                    AlertManager.showAlert("tesss")
                  }
                }}
                title="吐司"
              />
            </View>
            <View style={styles.buttonContainer}>
              <Button
                style={styles.buttonStyle}
                onPress={() => {
                  if (Platform.OS == 'android') {
                    BMCUI.showConfirmDialogWithCancelable(false, "你点击了按钮222！", "确定", (result) => {
                      console.log("你点击了取确定按钮，结果为：" + result);
                    });
                    // BMCUI.showConfirmDialog("你点击了按钮222！", "确定", (result) => {
                    //   console.log("你点击了确定，结果为：" + result);
                    // });
                    // BMCUI.showConfirmDialogWithCancelableError((result) => {
                    //   console.log("你点击了确定，结果为：" + result);
                    // }, true, "你点击了按钮222！", "确定");
                  } else {
                    Alert.alert("ios undefine");
                    
                  }
                }}
                title="单按钮提示框"
              />
            </View>
            <View style={styles.buttonContainer}>
              <Button
                style={styles.buttonStyle}
                onPress={() => {
                  if (Platform.OS == 'android') {
                    // BMCUI.showConfirmVsCancelDialog("你点击了按钮333！", "取消", "确定", (result) => {
                    //   console.log("你点击了取消单按钮，结果为：" + result);
                    // }, (result) => {
                    //   console.log("你点击了取确定按钮，结果为：" + result);
                    // });
                    showConfirmVsCancelPromiseDialog("你点击了按钮333！", "取消", "确定");
                  } else {
                    Alert.alert("ios undefine");
                  }
                }}
                title="双按钮提示框"
              />
            </View>
            <View style={styles.sectionContainer}>
              <Text style={styles.sectionTitle}>Step One 111</Text>
              <Text style={styles.sectionDescription}>
                Edit <Text style={styles.highlight}>App.js</Text> to change this
                screen and then come back to see your edits.
              </Text>
            </View>
            <View style={styles.sectionContainer}>
              <Text style={styles.sectionTitle}>See Your Changes 2222</Text>
              <Text style={styles.sectionDescription}>
                <ReloadInstructions />
              </Text>
            </View>
            <View style={styles.sectionContainer}>
              <Text style={styles.sectionTitle}>Debug 3333</Text>
              <Text style={styles.sectionDescription}>
                <DebugInstructions />
              </Text>
            </View>
            <View style={styles.sectionContainer}>
              <Text style={styles.sectionTitle}>Learn More 4444</Text>
              <Text style={styles.sectionDescription}>
                Read the docs to discover what to do next:
              </Text>
            </View>
            <LearnMoreLinks />
          </View>
        </ScrollView> 
       </SafeAreaView>
     </>
  );
};

const styles = StyleSheet.create({
  scrollView: {
    backgroundColor: Colors.lighter,
  },
  engine: {
    position: 'absolute',
    right: 0,
  },
  body: {
    backgroundColor: Colors.white,
  },
  sectionContainer: {
    marginTop: 32,
    paddingHorizontal: 24
  },
  buttonContainer: {
    marginTop: 5,
    paddingHorizontal: 24
  },
  sectionTitle: {
    fontSize: 24,
    fontWeight: '600',
    color: "#FF0000",
  },
  sectionDescription: {
    marginTop: 8,
    fontSize: 18,
    fontWeight: '400',
    color: Colors.dark,
  },
  highlight: {
    fontWeight: '700',
  },
  footer: {
    color: Colors.dark,
    fontSize: 12,
    fontWeight: '600',
    padding: 4,
    paddingRight: 12,
    textAlign: 'right',
  },
});

export default App;
