import React from 'react';
import PropTypes from "prop-types";
import { requireNativeComponent, View } from 'react-native';
import { BMCUI, ImagePicker } from './ui.js'
/**
 * Composes `View`.
 *
 * - src: string
 * - borderWidth: number
 * - cornerRadius: number
 * - resizeMode: 'contain' | 'cover' | 'stretch' | 'center'
 */
// const RoundImage = requireNativeComponent('RoundImage', {
//     propTypes: {
//         src: PropTypes.string,//定义传输属性类型
//         cornerRadius: PropTypes.number,
//         borderWidth: PropTypes.number,
//         ...View.propTypes // 包含默认的View的属性
//     }
// });
const RoundImage = requireNativeComponent('RoundImage');

async function choosePic(openCamera, selectPic, callback) {
    try {
        const {
            path,
            paths
        } = await ImagePicker.choosePic(openCamera, selectPic);

        console.log("path:" + path + " / paths:" + paths);
        BMCUI.show("path:" + path + " / paths:" + paths);
        if (path) {
            callback(path)
        } else if (paths && paths.length > 0) {
            callback(paths[0])
        }
    } catch (e) {
        console.error(e);
    }
}

function imageClick(callback) {
    if (Platform.OS == 'android') {
        choosePic(ImagePicker.OPEN_CAMERA, ImagePicker.SELECTED_IMAGES, callback);
    } else {
        Alert.alert("ios undefine");
    }
}

export default class CustomRoundImageView extends React.Component {
    constructor(props) {
        super(props);
        this._onChange = this._onChange.bind(this);
        this.state = {
            imgUrl: this.props.src
        };
    }
    componentDidMount() {
        console.log("CustomRoundImageView componentDidMount : " + RoundImage + " / default img:" + this.state.imgUrl);
    }
    _onChange(event) {
        console.log("onChange props:" + this.props + " / event:" + event);
        if (event.nativeEvent.message) {
            BMCUI.show("get event:" + event.nativeEvent.message);
        }
        imageClick((path) => {
            this.setState({
                // imgUrl: "https://reactnative.dev/docs/assets/p_cat2.png"
                imgUrl: path
            });
        })
        if (!this.props.onChangeMessage) {
            return;
        }
        this.props.onChangeMessage(event.nativeEvent.message);
    }
    render() {
        return <RoundImage {...this.props} src={this.state.imgUrl} style={this.props.style} onChange={this._onChange} />;
    }
}
CustomRoundImageView.propTypes = {
    /**
     * Callback that is called continuously when the user is dragging the map.
     */
    onChangeMessage: PropTypes.func,
    src: PropTypes.string,//定义传输属性类型
    cornerRadius: PropTypes.number,
    borderWidth: PropTypes.number,
};