import React, { useState } from 'react';
import {
    View,
    Text,
    Image,
    TextInput,
    DeviceEventEmitter,
    NativeEventEmitter,
    TouchableHighlight,
    TouchableNativeFeedback,
    Platform,
    Alert,
    NativeModules
} from 'react-native';
import { BMCUI, ImagePicker } from './ui.js'

async function choosePic(openCamera, selectPic, callback) {
    try {
        const {
            path,
            paths
        } = await ImagePicker.choosePic(openCamera, selectPic);

        console.log("path:" + path + " / paths:" + paths);
        BMCUI.show("path:" + path + " / paths:" + paths);
        if (path) {
            callback(path)
        } else if (paths && paths.length > 0) {
            callback(paths[0])
        }
    } catch (e) {
        console.error(e);
    }
}

function imageClick(callback) {
    if (Platform.OS == 'android') {
        choosePic(ImagePicker.OPEN_CAMERA, ImagePicker.SELECTED_IMAGES, callback);
    } else {
        Alert.alert("ios undefine");
    }
}

function Cat(props) {
    /** 
     * useState is a Hook that lets you add state to function components. 
     * useState does two things:
     * 1:it creates a “state variable” with an initial value—in this case the state variable is 'imgUrl' and i
     *  ts initial value is 'https://reactnative.dev/docs/assets/p_cat2.png'
     * 2:it creates a function to set that state variable’s value—setImgUrl
     * It doesn’t matter what names you use. But it can be handy to think of the pattern as [<getter>, <setter>] = useState(<initialValue>).
     * 
     * 虽然imgUrl使用了常量关键字const，但它看起来还是可以修改！
     * What is happening is when a state-setting function like setImgUrl is called, its component will re-render. 
     * In this case the Cat function will run again—and this time, useState will give us the next value of imgUrl. 
     * Cat重新刷新，导致useSate重新创建，而不是修改之前得imgUrl得值
    */
    const [imgUrl, setImgUrl] = useState("https://reactnative.dev/docs/assets/p_cat2.png");
    return (
        <View style={{ flexDirection: "row" }}>
            <TouchableNativeFeedback onPress={() => imageClick((path) => { setImgUrl(path) })} >
                <Image
                    source={{
                        uri: imgUrl,
                    }}
                    style={{ width: 120, height: 120 }}
                />
            </TouchableNativeFeedback>
            <Text style={{ padding: 10, fontSize: 42, flexWrap: "wrap" }}>
                {props.textTrans.split(' ').map((word) => word && '🍕').join(' ')}
            </Text>
        </View>
    );
}
export default class CustomerView extends React.Component {
    constructor(props) {
        super(props);
        console.log("CustomerView constructor");
        //老式的 class 组件在使用 state 的写法上有所不同
        this.state = {
            textTrans: ''
        };
    }

    componentDidMount() {
        console.log("CustomerView componentDidMount");
        if (Platform.OS == 'android') {
            this.eventListener = DeviceEventEmitter.addListener('msg', (a) => {
                // alert('收到通知：' + a);
                console.log("收到通知：" + a);
                if (a && a.test) {
                    tip = a.test
                } else {
                    tip = a
                }
                BMCUI.showConfirmDialogWithCancelable(false, "收到新消息：" + tip, "确定", (result) => {
                    console.log("你点击了取确定按钮，结果为：" + result);
                });
            });
        } else {
            const alertEmitter = new NativeEventEmitter(NativeModules.AlertManager)
            this.subscription = alertEmitter.addListener('AlertEvent', (a) => {
                console.log("你收到事件:" + a.btnTitle);
            });
        }
    }

    shouldComponentUpdate(nextProps, nextState, nextContext) {
        console.log("CustomerView shouldComponentUpdate nextProps:" + nextProps);
        console.log("CustomerView shouldComponentUpdate nextState.textTrans:" + nextState.textTrans + " / currState.textTrans:" + this.state.textTrans
            + "nextState.imgUrl:" + nextState.imgUrl + " / currState.imgUrl:" + this.state.imgUrl);

        return (nextState.textTrans || this.state.textTrans)
            && (nextState.textTrans.split(' ').length != this.state.textTrans.split(' ').length
                || (nextState.textTrans.length == 1 && this.state.textTrans.length == 0))
    }

    componentWillUnmount() {
        console.log("CustomerView componentWillUnmount");
        if (Platform.OS == 'android') {
            this.eventListener.remove(); // Removes the listener
        } else {
            this.subscription.remove();
        }
    }

    componentDidCatch(error, errorInfo) {
        console.log("CustomerView componentDidCatch");
    }

    render() {
        return (
            <>
                <Cat textTrans={this.state.textTrans} />
                <TextInput
                    style={{
                        height: 40,
                        margin: 10,
                        borderColor: 'gray',
                        borderWidth: 1
                    }}
                    placeholder="Type here to translate!"
                    onChangeText={text => this.setState({ textTrans: text })}
                    defaultValue={this.state.textTrans}
                />
            </>
        );
    }
}