package com.hikcreate.controller;

import com.alibaba.fastjson.JSONObject;
import com.hikcreate.drv_photo_pic.DrvPhoto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;

/**
 * @author lifuyi
 * @date ${Date}
 * @description
 */
@RestController
@RequestMapping("/pic")
@Validated
public class PicController {

    @Autowired
    private DrvPhoto drvPhoto;

    @GetMapping("/drvPhotoHis")
    public void getHisDrvPhoto(@RequestParam("time") String time, HttpServletResponse response){
        try {
            boolean result=drvPhoto.getHisDrvPhoto(time);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("result",result);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(jsonObject.toJSONString());
        }catch (Exception e) {
            e.printStackTrace();
        }
    }


}
