package com.hikcreate.drv_photo_pic.impl;

import com.hikcreate.drv_photo_pic.DrvPhoto;
import com.hikcreate.utils.DateUtil;
import oracle.sql.BLOB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;


/**
 * @author lifuyi
 * @date ${Date}
 * @description
 */
@Service("drvPhotoImpl")
public class DrvPhotoImpl implements DrvPhoto {

    private static Logger logger = LoggerFactory.getLogger(DrvPhotoImpl.class);
    @Value("${url}")
    private static String url;
    @Value("${username}")
    private static String username;
    @Value("${password}")
    private static String password;
    @Value("${roundDay}")
    private static int roundDay;

    private static String startTime;
    private static String endTime;
    private static String sfzmhm;
    private static BLOB zp;
    private static String gxsj;
    private static String xzqh;
    private static String xh;
    private static String flag;
    private static String rksj;
    private static String fzjg;
    private static String sfzzp;
    private static String mqzp;
    private static String bjcsbj;

    /**
     * 同步历史图片，图片同步到time时间
     *
     * @param time
     * @return
     */
    @Override
    public boolean getHisDrvPhoto(String time) {
        try {
            endTime = time;
            Class.forName("oracle.jdbc.OracleDriver");
            Connection connection1 = DriverManager.getConnection(url, username, password);
            //获取最小时间
            String minTimeSql = "select  min(GXSJ) mtime from GYJG.DRV_PHOTO";
            PreparedStatement pstm1 = connection1.prepareStatement(minTimeSql);
            ResultSet resultSet1 = pstm1.executeQuery();
            while (resultSet1.next()) {
                startTime = resultSet1.getString("MTIME").substring(0, 10);
            }
            resultSet1.close();
            pstm1.close();
            connection1.close();
            //循环获取图片
            String sql;
            String lastTime;
            while (endTime.compareTo(startTime) > 0 || endTime.compareTo(startTime) == 0) {
                lastTime = DateUtil.formatDate(DateUtil.getPastDate(DateUtil.parseDate(endTime), roundDay));
                Connection connection = DriverManager.getConnection(url, username, password);
                sql = "select * from GYJG.DRV_PHOTO where to_char(GXSJ,'yyyy-mm-dd')>='" + lastTime + "' and to_char(GXSJ,'yyyy-mm-dd')<'"
                        + endTime + "' and ZP is not null and fzjg is not null and sfzmhm is not null";
                PreparedStatement pstm = connection.prepareStatement(sql);
                ResultSet resultSet = pstm.executeQuery();
                while (resultSet.next()) {
                    sfzmhm=resultSet.getString("SFZMHM");
                    zp= (BLOB) resultSet.getBlob("ZP");
                    gxsj=resultSet.getString("GXSJ");
                    xzqh=resultSet.getString("XZQH");
                    flag=resultSet.getString("FLAG");
                    xh=resultSet.getString("XH");
                    rksj=resultSet.getString("RKSJ");
                    fzjg=resultSet.getString("FZJG");


                }
                endTime = lastTime;
                resultSet.close();
                pstm.close();
                connection.close();
            }

        } catch (Exception e) {
            e.printStackTrace();
        } finally {

        }
        return true;
    }


    public static void main(String[] args) {
        String s = "2019-07-02";
        String s1 = DateUtil.formatDate(DateUtil.getPastDate(DateUtil.parseDate(s), -4));
        System.out.println(s1);
        String time = "2019-07-02 00:00:00";
        System.out.println(time.substring(0, 10));
        System.out.println(s.compareTo(time.substring(0, 10)));
    }

}
