package com.hikcreate.ftp.proxy.modules.ftp.api;

import cn.hutool.core.codec.Base64Encoder;
import com.alibaba.fastjson.JSONObject;
import com.hikcreate.ftp.proxy.base.exception.BusinessException;
import com.hikcreate.ftp.proxy.base.response.Response;
import com.hikcreate.ftp.proxy.base.response.ResponseGenerator;
import com.hikcreate.ftp.proxy.configbean.FtpConfigBean;
import com.hikcreate.ftp.proxy.modules.ftp.param.request.UploadIllegalReportReq;
import com.hikcreate.ftp.proxy.modules.ftp.param.response.PicByte;
import com.hikcreate.ftp.proxy.utils.FtpUtil;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Decoder;

import javax.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author MOUBK
 * @create 2019/6/28 10:09
 */
@RestController
@RequestMapping("/ftp")
@Validated
public class FtpProxyWebApi {

    private static InputStream inputStream;
    private static String host;
    private static String userName;
    private static String password;
    private static String path;
    private static String filename;
    private static BufferedReader br;
    private static Logger logger = LoggerFactory.getLogger(FtpProxyWebApi.class);
    @Autowired
    private FtpConfigBean ftpConfigBean;

    /**
     * @return
     * @Description 列表
     * @Param
     */
    @GetMapping("/download")
    public void list(@RequestParam("param") String[] param, HttpServletResponse response) {
        try {
            System.out.println(JSONObject.toJSONString(param));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("test", "test".getBytes());
            jsonObject.put("test1", "test1".getBytes());
            jsonObject.put("test2", "test2".getBytes());
            jsonObject.put("test3", "test3".getBytes());
            jsonObject.put("test4", "test4".getBytes());
            jsonObject.put("test5", "test5".getBytes());
            jsonObject.put("test6", "test6".getBytes());
            jsonObject.put("test7", "test7".getBytes());
            jsonObject.put("test8", "test8".getBytes());
            jsonObject.put("test9", "test9".getBytes());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(jsonObject.toJSONString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * ftp
     *
     * @param urls
     * @return
     */
    @PostMapping("/testFtpUtil")
    public synchronized PicByte testFtpUtil(@RequestParam("urls") String urls) {
        PicByte picByte = new PicByte();
        FtpUtil ftpUtil = null;
        try {
            Map<String, byte[]> map = new HashMap<>();
            String[] urlArr = urls.split(",");
            for (String str : urlArr) {
                paramUrl(str);
                ftpUtil = new FtpUtil(host, 21, userName, password);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                boolean flag = ftpUtil.downloadPicFile(path, filename, bos);
                if (flag) {
                    byte[] bytes = bos.toByteArray();
                    map.put(str, bytes);
                } else {
                    logger.info("获取图片失败");
                }
            }
            picByte.setMap(map);
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (ftpUtil != null) {
                ftpUtil = null;
            }
        }
        return picByte;
    }


    @GetMapping("/makeDir")
    public Response<Boolean> list(@RequestParam("dir") String dir) {
        FtpUtil ftpUtil = new FtpUtil(ftpConfigBean.getIp(),
                ftpConfigBean.getPort(),
                ftpConfigBean.getUsername(),
                ftpConfigBean.getPassword());
        try {
            boolean result = ftpUtil.makeDir(dir);
            return ResponseGenerator.success(result);
        } catch (IOException e) {
            return ResponseGenerator.fail(e.toString());
        }
    }

    /**
     * 违法举报图片上传接口
     */
    @PostMapping("/uploadIllegalReport")
    public Response<Void> uploadPic(@RequestBody @Validated UploadIllegalReportReq request) {
        try {
            FtpUtil ftpUtil = new FtpUtil(ftpConfigBean.getIp(),
                    ftpConfigBean.getPort(),
                    ftpConfigBean.getUsername(),
                    ftpConfigBean.getPassword());
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes = decoder.decodeBuffer(request.getFileBase64Content());
            InputStream in = new ByteArrayInputStream(bytes);
            ftpUtil.uploadFile(in, ftpConfigBean.getIllegalReportDir() + request.getDate(), request.getFileName());
            return ResponseGenerator.success();
        } catch (Exception e) {
            throw new BusinessException(e);
        }
    }


    /**
     * http
     *
     * @param urls
     * @return
     */
    @PostMapping("/testHttpUtil")
    public synchronized PicByte testHttpUtil(@RequestParam("urls") String urls) {
        String[] urlArr = urls.split(",");
        Map<String, byte[]> map = new HashMap<>();
        PicByte picByte = new PicByte();
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream bos = null;
        try {
            for (String str : urlArr) {
                URL url = new URL(str);
                httpURLConnection = (HttpURLConnection) url.openConnection();
                httpURLConnection.setConnectTimeout(3000);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod("GET");
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) {
                    // 从服务器返回一个输入流
                    inputStream = httpURLConnection.getInputStream();
                    if (inputStream != null && inputStream.available() > 0) {

                        bos = new ByteArrayOutputStream();
                        int length;
                        byte[] buf = new byte[1024 * 2];
                        while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                            bos.write(buf, 0, length);
                        }
                        ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
                        bos.flush();
                        bos.close();
                        byte[] buffer = new byte[fis.available()];
                        int offset = 0;
                        int numRead = 0;
                        while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                            offset += numRead;
                        }
                        if (offset != buffer.length) {
                            throw new IOException("Could not completely read file ");
                        }
                        fis.close();
                        map.put(str, buffer);
                    }
                    inputStream.close();
                }
                picByte.setMap(map);
            }
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return picByte;
    }


    /**
     * ftp总队的
     *
     * @param url
     * @return
     */
    @GetMapping("/ftpPic")
    public  void ftpPic(@RequestParam("url") String url, HttpServletResponse response) {
        FtpUtil ftpUtil = null;
        byte[] bytes=null;
        try {
            paramUrl(url);
            ftpUtil = new FtpUtil(host, 21, userName, password);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean flag = ftpUtil.downloadPicFile(path, filename, bos);
            if (flag) {
                bytes = bos.toByteArray();
            } else {
                logger.info("获取图片失败");
            }
        } catch (Throwable e) {
           e.printStackTrace();
        } finally {
            if (ftpUtil != null) {
                ftpUtil = null;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            response.addHeader(
                    "Content-Disposition",
                    "attachment; filename=\"test.jpg\"");
            response.getOutputStream().write(bytes);
        } catch (IOException e) {

        }
    }

    /**
     * http总队的
     *
     * @param urls
     * @return
     */
    @GetMapping("/httpPic")
    public void httpPic(@RequestParam("url") String urls, HttpServletResponse response) {
        Map<String, byte[]> map = new HashMap<>();
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream bos = null;
        byte[] buffer=null;
        try {
                URL url = new URL(urls);
                httpURLConnection = (HttpURLConnection) url.openConnection();
                httpURLConnection.setConnectTimeout(3000);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod("GET");
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) {
                    // 从服务器返回一个输入流
                    inputStream = httpURLConnection.getInputStream();
                    if (inputStream != null && inputStream.available() > 0) {
                        bos = new ByteArrayOutputStream();
                        int length;
                        byte[] buf = new byte[1024 * 2];
                        while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                            bos.write(buf, 0, length);
                        }
                        ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
                        bos.flush();
                        bos.close();
                        buffer = new byte[fis.available()];
                        int offset = 0;
                        int numRead = 0;
                        while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                            offset += numRead;
                        }
                        if (offset != buffer.length) {
                            throw new IOException("Could not completely read file ");
                        }
                        fis.close();
                    }
                    inputStream.close();
                }
        } catch (Throwable e) {
           e.printStackTrace();
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            response.addHeader(
                    "Content-Disposition",
                    "attachment; filename=\"test.jpg\"");
            response.getOutputStream().write(buffer);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    /**
     * http总队的
     *
     * @param
     * @return
     */
    @GetMapping("/showImg")
    public void showImg(@RequestParam("url") String urls,HttpServletResponse response) {
        try {
            String html = "<html><body><img src=\"/ftp/httpPic?url="+urls+"\"/></body></html>";
            response.getOutputStream().write(html.getBytes("UTF-8"));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }



    @PostMapping("/downloadByUrls")
    public synchronized PicByte list2(@RequestParam("urls") String urls, HttpServletResponse response) {
        PicByte picByte = new PicByte();
        FTPClient ftpClient = null;
        try {
            Map<String, byte[]> map = new HashMap<>();
            String[] urlArr = urls.split(",");
            for (String str : urlArr) {
                paramUrl(str);

                ftpClient = new FTPClient();
                ftpClient.connect(host, 21);
                ftpClient.login(userName, password);
                ftpClient.changeWorkingDirectory(path);
                ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
                inputStream = ftpClient.retrieveFileStream(filename);
                if (inputStream != null && inputStream.available() > 0) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int length;
                    byte[] buf = new byte[2048];
                    while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                        bos.write(buf, 0, length);
                    }
                    ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
                    bos.flush();
                    bos.close();
                    byte[] buffer = new byte[fis.available()];
                    int offset = 0;
                    int numRead = 0;
                    while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                        offset += numRead;
                    }
                    if (offset != buffer.length) {
                        throw new IOException("Could not completely read file ");
                    }
                    fis.close();
                    map.put(str, buffer);
                }
            }
            picByte.setMap(map);
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return picByte;
    }

    /**
     * @return
     * @Description 列表
     * @Param
     */
    @PostMapping("/download1")
    public synchronized void list1(@RequestBody JSONObject jsonParam, HttpServletResponse response) {
        try {
            List<String> list = new ArrayList<String>();
            //解析参数
            String param = jsonParam.getString("param");
            paramUrl(param);


            //方式二
            FTPClient ftpClient = new FTPClient();
            ftpClient.connect(host, 21);
            ftpClient.login(userName, password);
            ftpClient.changeWorkingDirectory(path);
            ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
            inputStream = ftpClient.retrieveFileStream(filename);

            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length;
            byte[] buf = new byte[2048];
            while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                bos.write(buf, 0, length);
            }
            ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
            bos.flush();
            bos.close();
            byte[] buffer = new byte[fis.available()];
            int offset = 0;
            int numRead = 0;
            while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file ");
            }
            fis.close();
            String asB64 = "data:image/jpg;base64," + new Base64Encoder().encode(buffer);

/*            byte[] byt = new byte[inputStream.available()];
            System.out.println("字节长度--------------:"+byt.length);
            inputStream.read(byt);
            byte[] base = Base64.encodeBase64(byt);
            String imgStr = new String(base, "utf-8");
            System.out.println("图片："+imgStr);*/


            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(asB64);
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    private static void paramUrl(String url) {
        String[] split = url.split("@");
        host = split[1].split(":")[0];
        userName = split[0].split(":")[1].substring(2);
        password = split[0].split(":")[2];
        path = split[1].split(":")[1].substring(2).substring(0, split[1].split(":")[1].substring(2).lastIndexOf("/") + 1);
        String[] split1 = split[1].split(":")[1].substring(2).split("/");
        filename = split1[split1.length - 1];
    }

    public static void main(String[] args) {
        try {
            FtpUtil ftpUtil = new FtpUtil("10.197.236.151", 21, "yfbftp", "1234qwer");
            String str = "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";
            String fileName = "test2.jpeg";
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes = decoder.decodeBuffer(str);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ftpUtil.uploadFile(in, "hik_pic/", fileName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
