package com.hikcreate.ftp.proxy.utils;

import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * FTP工具类，用于获取ftp连接，上传文件，删除文件等对ftp的操作
 * @author hulei
 */
public class FtpUtil {

    private static Logger logger = Logger.getLogger(FtpUtil.class);

    /**
     * ftp 根目录
     */
    private static final String ROOTPATH = "/";
    /**
     * ftp 字符集
     */
    private static final String FTP_ENCODE = "UTF-8";
    /**
     * ftp 连接默认超时时间
     */
    private static final int DEFAULT_TIMEOUT = 30*1000;
    /**
     * FTP客户端
     */
    FTPClient ftpClient = null;
    /**
     * 获取ftpUtil实例
     * @param ftpIp ftp Ip
     * @param port ftp 端口
     * @param userName ftp用户名
     * @param passWord ftp 用户密码
     * @return FTPClient
     * @throws IOException
     */
    public FtpUtil(String ftpIp, int port, String userName, String passWord) {
        try {
            ftpClient = new FTPClient();
            ftpClient.connect(ftpIp);
            ftpClient.setDefaultPort(port);
            ftpClient.setDataTimeout(DEFAULT_TIMEOUT);
            ftpClient.setControlEncoding(FTP_ENCODE);
            ftpClient.enterLocalPassiveMode();
            boolean isConnect = ftpClient.login(userName,passWord);
            if(!isConnect) {
                logger.error("Connection the FtpServer Is Failed!");
                ftpClient.disconnect();
            }
        } catch (IOException e) {
            logger.error("Connection the FtpServer Is Failed! " + e.toString());
        }
    }

    /**
     * ftp文件上传
     * @param ins 文件输入流
     * @param uploadPath 上传路径
     * @param fileName 文件名
     * @return boolean true/false
     */
    public boolean uploadFile(InputStream ins, String uploadPath, String fileName) {
        boolean flag = false;

        if(ftpClient != null) {
            try {
                //设置上传文件类型，默认为文本，图片需要设置成二进制，否则图片失真
                ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);

                //切换到上传目录
                boolean change = ftpClient.changeWorkingDirectory(uploadPath);

                if(change) {
                    flag = ftpClient.storeFile(new String(fileName.getBytes("GBK"),"iso-8859-1"), ins);
                } else {
                    boolean flag2=ftpClient.makeDirectory(uploadPath);
                    boolean flag1=ftpClient.changeWorkingDirectory(uploadPath);
                    System.out.println(flag2+"-=-----------------="+flag1);
                    flag = ftpClient.storeFile(fileName, ins);
                }

            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    /**
     * 切换回上级菜单
     */
    public void changeToParentDirectory() {
        try {
            ftpClient.changeToParentDirectory();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 关闭ftp连接
     */
    public void closeFtp() {
        try {
            ftpClient.logout();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if(ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 下载文件
     * @param remotePath
     * @param fileName
     * @param os
     * @return
     */
    public boolean downloadPicFile(String remotePath,String fileName,OutputStream os) {
        boolean flag = false;

        try {
            ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);
            ftpClient.enterLocalPassiveMode();
            flag = ftpClient.changeWorkingDirectory(new String(remotePath.getBytes(),"ISO-8859-1"));
            if (flag) {
                ftpClient.retrieveFile(fileName, os);
                os.flush();
                os.close();
                flag = true;
            } else {
                flag = false;
            }
            ftpClient.logout();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                } catch (IOException ioe) {

                }
            }
        }

        return flag;
    }

    public boolean makeDir(String dir) throws IOException {
        return ftpClient.changeWorkingDirectory(dir);
    }
}
