package com.hikcreate.ftp.proxy.modules;

import cn.hutool.core.codec.Base64Encoder;
import com.alibaba.fastjson.JSONObject;
import com.hikcreate.ftp.proxy.entity.PicByte;
import com.hikcreate.ftp.proxy.utils.FtpUtil;
import org.apache.commons.net.ftp.FTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


import org.apache.commons.net.ftp.FTPClient;

import javax.servlet.http.HttpServletResponse;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author MOUBK
 * @create 2019/6/28 10:09
 */
@RestController
@RequestMapping("/ftp")
@Validated
public class FtpProxyWebApi {

    private static InputStream inputStream;
    private static String host;
    private static String userName;
    private static String password;
    private static String path;
    private static String filename;
    private static BufferedReader br;
    private static Logger logger = LoggerFactory.getLogger(FtpProxyWebApi.class);

    /**
     * @return
     * @Description 列表
     * @Param
     */
    @GetMapping("/download")
    public void list(@RequestParam("param") String[] param, HttpServletResponse response) {
        try {
            System.out.println(JSONObject.toJSONString(param));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("test", "test".getBytes());
            jsonObject.put("test1", "test1".getBytes());
            jsonObject.put("test2", "test2".getBytes());
            jsonObject.put("test3", "test3".getBytes());
            jsonObject.put("test4", "test4".getBytes());
            jsonObject.put("test5", "test5".getBytes());
            jsonObject.put("test6", "test6".getBytes());
            jsonObject.put("test7", "test7".getBytes());
            jsonObject.put("test8", "test8".getBytes());
            jsonObject.put("test9", "test9".getBytes());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(jsonObject.toJSONString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @PostMapping("/testFtpUtil")
    public synchronized PicByte testFtpUtil(@RequestParam("urls") String urls) {
        PicByte picByte = new PicByte();
        FtpUtil ftpUtil = null;
        try {
            Map<String, byte[]> map = new HashMap<>();
            String[] urlArr = urls.split(",");
            for (String str : urlArr) {
                paramUrl(str);
                ftpUtil = new FtpUtil(host, 21, userName, password);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                boolean flag = ftpUtil.downloadPicFile(path, filename, bos);
                if (flag) {
                    byte[] bytes = bos.toByteArray();
                    map.put(str, bytes);
                } else {
                    logger.info("获取图片失败");
                }
            }
            picByte.setMap(map);
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (ftpUtil != null) {
                ftpUtil = null;
            }
        }
        return picByte;
    }


    @PostMapping("/testHttpUtil")
    public synchronized PicByte testHttpUtil(@RequestParam("urls") String urls) {
        String[] urlArr = urls.split(",");
        Map<String, byte[]> map = new HashMap<>();
        PicByte picByte = new PicByte();
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream bos =null;
        try {
            for (String str : urlArr) {
                URL url = new URL(str);
                httpURLConnection = (HttpURLConnection) url.openConnection();
                httpURLConnection.setConnectTimeout(3000);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod("GET");
                int responseCode = httpURLConnection.getResponseCode();
                if (responseCode == 200) {
                    // 从服务器返回一个输入流
                    inputStream = httpURLConnection.getInputStream();
                    if(inputStream != null && inputStream.available() > 0){

                        bos = new ByteArrayOutputStream();
                        int length;
                        byte[] buf = new byte[1024*2];
                        while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                            bos.write(buf, 0, length);
                        }
                        ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
                        bos.flush();
                        bos.close();
                        byte[] buffer = new byte[fis.available()];
                        int offset = 0;
                        int numRead = 0;
                        while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                            offset += numRead;
                        }
                        if (offset != buffer.length) {
                            throw new IOException("Could not completely read file ");
                        }
                        fis.close();
                        map.put(str, buffer);
                    }
                    inputStream.close();
                }
                picByte.setMap(map);
            }
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if(inputStream!=null){
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if(bos!=null){
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return picByte;
    }


    @PostMapping("/downloadByUrls")
    public synchronized PicByte list2(@RequestParam("urls") String urls, HttpServletResponse response) {
        PicByte picByte = new PicByte();
        FTPClient ftpClient = null;
        try {
            Map<String, byte[]> map = new HashMap<>();
            String[] urlArr = urls.split(",");
            for (String str : urlArr) {
                paramUrl(str);

                ftpClient = new FTPClient();
                ftpClient.connect(host, 21);
                ftpClient.login(userName, password);
                ftpClient.changeWorkingDirectory(path);
                ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
                inputStream = ftpClient.retrieveFileStream(filename);
                if (inputStream != null && inputStream.available() > 0) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int length;
                    byte[] buf = new byte[2048];
                    while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                        bos.write(buf, 0, length);
                    }
                    ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
                    bos.flush();
                    bos.close();
                    byte[] buffer = new byte[fis.available()];
                    int offset = 0;
                    int numRead = 0;
                    while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                        offset += numRead;
                    }
                    if (offset != buffer.length) {
                        throw new IOException("Could not completely read file ");
                    }
                    fis.close();
                    map.put(str, buffer);
                }
            }
            picByte.setMap(map);
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return picByte;
    }

    /**
     * @return
     * @Description 列表
     * @Param
     */
    @PostMapping("/download1")
    public synchronized void list1(@RequestBody JSONObject jsonParam, HttpServletResponse response) {
        try {
            List<String> list = new ArrayList<String>();
            //解析参数
            String param = jsonParam.getString("param");
            paramUrl(param);


            //方式二
            FTPClient ftpClient = new FTPClient();
            ftpClient.connect(host, 21);
            ftpClient.login(userName, password);
            ftpClient.changeWorkingDirectory(path);
            ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
            inputStream = ftpClient.retrieveFileStream(filename);

            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length;
            byte[] buf = new byte[2048];
            while (-1 != (length = inputStream.read(buf, 0, buf.length))) {
                bos.write(buf, 0, length);
            }
            ByteArrayInputStream fis = new ByteArrayInputStream(bos.toByteArray());
            bos.flush();
            bos.close();
            byte[] buffer = new byte[fis.available()];
            int offset = 0;
            int numRead = 0;
            while (offset < buffer.length && (numRead = fis.read(buffer, offset, buffer.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file ");
            }
            fis.close();
            String asB64 = "data:image/jpg;base64," + new Base64Encoder().encode(buffer);

/*            byte[] byt = new byte[inputStream.available()];
            System.out.println("字节长度--------------:"+byt.length);
            inputStream.read(byt);
            byte[] base = Base64.encodeBase64(byt);
            String imgStr = new String(base, "utf-8");
            System.out.println("图片："+imgStr);*/


            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(asB64);
        } catch (Throwable e) {
            e.printStackTrace();
            Writer writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            logger.error("打印错误:" + writer.toString());
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void paramUrl(String url) {
        String[] split = url.split("@");
        host = split[1].split(":")[0];
        userName = split[0].split(":")[1].substring(2);
        password = split[0].split(":")[2];
        path = split[1].split(":")[1].substring(2).substring(0, split[1].split(":")[1].substring(2).lastIndexOf("/") + 1);
        String[] split1 = split[1].split(":")[1].substring(2).split("/");
        filename = split1[split1.length - 1];
    }


}
