package com.hikcreate.edl.pub.web.mobile.api.controller;

import com.hikcreate.common.sdk.response.statuscode.StatusCode;
import com.hikcreate.edl.common.distributed.lock.exception.DistributedLockException;
import com.hikcreate.edl.pub.web.mobile.domain.IBindService;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result.Result;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result.ResultGenerator;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.BodyDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.ResponseEncryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.AdminUnbindReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.AdminUnbindSmsValidReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindInfoQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindInfoReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindSmsValidReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.UnBindReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.BindInfoQueryRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.BindInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ResultList;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 绑定信息的controller
 *
 * @menu 提供给第三方接口
 * @author: xieshixiang
 * @time：2020/6/18 15:59
 **/
@RestController
@RequestMapping( "/vehicle" )
@Slf4j
public class BindInfoControlller extends BaseController {

    @Autowired
    IBindService service;

    /**
     * 绑定用户信息的接口
     *
     * @param req
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:27
     */
    @PostMapping( "bind" )
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Result bindInfo( @RequestBody @Validated BindInfoReq req ) {
        Result response = null;
        try {
            response = service.bind(req);
        } catch ( DistributedLockException e ) {
            log.error("分布式锁超时");
            return ResultGenerator.fail(StatusCode.REPEAT_SUBMIT);
        } catch ( Exception e ) {
            log.error("系统异常：{}", e);
            return ResultGenerator.fail(StatusCode.SYSTEM_ERROR);
        }
        return response;
    }

    /**
     * 车辆绑定短信验证
     * @param req
     * @return
     */
    @PostMapping("bind/smsValid")
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Result<BindInfoRes> bindSmsValid(@RequestBody @Validated BindSmsValidReq req) {
        return service.bindSmsValid(req);
    }


    /**
     * 解绑用户信息的接口
     *
     * @param req
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:27
     */
    @PostMapping( "unbind" )
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Result unbindInfo( @RequestBody @Validated UnBindReq req ) {
        Result result = null;
        try {
             result = service.unbindInfo(req);
        } catch ( DistributedLockException e ) {
            return ResultGenerator.fail(StatusCode.REPEAT_SUBMIT);
        } catch ( Exception e ) {
            log.error("系统异常：{}", e);
            return ResultGenerator.fail(StatusCode.SYSTEM_ERROR);
        }
        return result;
    }

    /**
     * 车辆解绑发送短信(后台操作)
     * @param req
     * @return
     */
    @PostMapping( "admin/unbind" )
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Result adminUnbind(@RequestBody @Validated AdminUnbindReq req ) {
        Result result = null;
        try {
            result = service.adminUnbind(req);
        } catch ( DistributedLockException e ) {
            return ResultGenerator.fail(StatusCode.REPEAT_SUBMIT);
        } catch ( Exception e ) {
            log.error("系统异常：{}", e);
            return ResultGenerator.fail(StatusCode.SYSTEM_ERROR);
        }
        return result;
    }

    /**
     * 车辆解绑短信验证（后台操作）
     * @param req
     * @return
     */
    @PostMapping( "admin/unbind/smsValid" )
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Result adminUnbindSmsValid(@RequestBody @Validated AdminUnbindSmsValidReq req) {
        Result result = null;
        try {
            result = service.adminUnbindSmsValid(req);
        } catch ( DistributedLockException e ) {
            return ResultGenerator.fail(StatusCode.REPEAT_SUBMIT);
        } catch ( Exception e ) {
            log.error("系统异常：{}", e);
            return ResultGenerator.fail(StatusCode.SYSTEM_ERROR);
        }
        return result;
    }

    /**
     * 绑定信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:31
     */
    @PostMapping( "query" )
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Result<ResultList<BindInfoQueryRes>> bindInfoQery( @RequestBody @Validated BindInfoQueryReq query ) {
        return ResultGenerator.success(new ResultList<BindInfoQueryRes>(service.selectByQuery(query)));
    }

}
