package com.hikcreate.edl.pub.web.mobile.domain;

import com.baomidou.mybatisplus.extension.service.IService;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result.Result;
import com.hikcreate.edl.pub.web.mobile.infra.model.entity.ParkBindInfo;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.*;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.BindInfoQueryRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.VehicleDrivingLicenseInfoRes;

import java.util.List;


/**
 * 客户绑定服务接口
 *
 * @author: xieshixiang
 * @time：2020/6/18 16:11
 **/
public interface IBindService extends IService<ParkBindInfo> {

    /**
     * 信息绑定接口
     *
     * @param req
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:32
     */
    Result bind( BindInfoReq req);

    /**
     * 车辆绑定短信验证接口
     * @param req
     * @return
     */
    Result bindSmsValid( BindSmsValidReq req);

    /**
     * 信息解绑
     * @param req
     * @return
     */
    Result unbindInfo( UnBindReq req );

    /**
     * 车辆解绑发送短信(后台操作)
     * @param req
     * @return
     */
    Result adminUnbind( AdminUnbindReq req);

    /**
     * 车辆解绑短信验证（后台操作）
     * @param req
     * @return
     */
    Result adminUnbindSmsValid(AdminUnbindSmsValidReq req);

    /**
     * 查询用户绑定信息
     * @param query
     * @return
     */
    List<BindInfoQueryRes> selectByQuery(BindInfoQueryReq query);

    /**
     * 年检信息查询接口
     *
     * @param query
     * @return
     */
    Result yearCheckInfo( H5BindInfoQuery query);

    /**
     * 保险信息查询接口
     * @param query
     * @return
     */
    Result insuranceInfo( H5BindInfoQuery query);

    /**
     * 违法信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:06
     */
    Result violationInfo( H5BindInfoQuery query);

    /**
     * 驾照信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:29
     */
    Result<VehicleDrivingLicenseInfoRes> drivingLicenseInfo(H5BindInfoQuery query);

    /**
     * 保存校验信息
     * @param userId
     * @param unqId
     * @param phone
     */
    void saveValid(String userId, String unqId, String phone);

    /**
     * 验证是否通过短信校验
     * @param userId
     * @param idCard
     * @return
     */
    Boolean checkValid(String userId, String idCard);
}
