package com.hikcreate.edl.pub.web.mobile.domain.impl;

import com.alibaba.fastjson.JSONObject;
import com.hikcreate.common.sdk.exception.BusinessException;
import com.hikcreate.edl.common.image.builder.domain.DlBackImageDO;
import com.hikcreate.edl.common.image.builder.domain.DlImageDO;
import com.hikcreate.edl.common.image.builder.refactor.DrawDispatcher;
import com.hikcreate.edl.pub.web.mobile.domain.CredentialsImageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.OutputStream;

/**
 * @author MOUBK
 * @create 2020/7/20 17:53
 */
@Slf4j
@Service
public class CredentialsImageServiceImpl implements CredentialsImageService {

    @Autowired
    private DrawDispatcher drawDispatcher;

    @Override
    public OutputStream genDlImage(DlImageDO params) {
        OutputStream outputStream;
        try {
            outputStream = drawDispatcher.drawDl(params);
        } catch (Exception e) {
            log.error("Gen DrivingLicense Image Error, param={}, msg={}", JSONObject.toJSONString(params), e);
            throw new BusinessException("获取驾驶证图片失败");
        }
        return outputStream;
    }


    /**
     * 生成驾驶证背面图片
     *
     * @param params 参数
     * @return
     */
    @Override
    public OutputStream genDlBackImage(DlBackImageDO params) {
        OutputStream outputStream;
        try {
            outputStream = drawDispatcher.drawDlBack(params);
        } catch (Exception e) {
            log.error("Gen DrivingLicense back Image Error, param={}, msg={}", JSONObject.toJSONString(params), e);
            throw new BusinessException("获取驾驶证图片失败");
        }
        return outputStream;
    }
}
