package com.hikcreate.edl.pub.web.mobile.infra.core.Result;

import com.hikcreate.common.sdk.response.statuscode.IStatusCode;
import com.hikcreate.common.sdk.response.statuscode.ProductCode;
import com.hikcreate.common.sdk.response.statuscode.StatusCodeHelper;
import lombok.AllArgsConstructor;

/**
 * @author: xieshixiang
 * @time：2020/6/24 10:28
 **/
@AllArgsConstructor
public enum ResultCode implements IStatusCode {

    /*SUCCESS(1000, "操作成功"),
    SYSTEM_ERROR(1001, "系统未知错误"),
    PERMISSION_DENIED(1002, "没有权限"),
    DATA_ERROR(1003, "数据错误"),
    REPEAT_SUBMIT(1004, "重复提交"),
    PARAM_ERROR(1005, "参数错误"),
    BUSINESS_ERROR(1006, "业务错误"),*/
    BIND_NUM_ERROR(1, "同一客户绑定认证不超过3辆"),
    UNBIND_TOTAL_ERROR(2, "30天内解绑次数超过10次,不能再次绑定认证"),
    USERID_PHONE_ERROR(3, "客户ID与手机号不一致"),
    CAR_MESSAGE_UNKNOWN(4, "车辆信息不存在"),
    CAR_PHONE_UNMATCHED(5, "手机号与车辆备案手机号不一致"),
    CAR_HAVE_BIND(6, "车辆已被绑定"),
    BIND_INFO_UNKNOWN(7, "绑定认证不存在"),
    DRIVING_LICENSE_UNKNOWN(8, "车主信息不存在或非贵阳驾驶证");

    private int customCode;
    private String msg;
    private StatusCodeHelper statusCodeHelper = new StatusCodeHelper(ProductCode.PARKING, ParkServiceCode.PARK_OPEN);

    ResultCode(int customCode, String msg) {
        this.customCode = customCode;
        this.msg = msg;
    }

    @Override
    public long getCode() {
        return statusCodeHelper.getCode(this.customCode);
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    public static void main( String[] args ) {
        for(ResultCode code :ResultCode.values()){
            System.out.println(code.getMsg()+"----"+code.getCode());
        }
    }
}
