package com.hikcreate.edl.pub.web.mobile.infra.core.page;

import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * description:
 *
 * @author: xieshixiang
 * @time：2020/6/18 16:18
 **/
public class PageResult<T> implements Serializable {
    private long allCount;
    private long allPages;
    private long pageNum;
    private long pageSize;
    private List<T> dataItems;

    public <R> PageResult<R> convert(Function<? super T, ? extends R> mapper) {
        List<R> collect = (List)this.dataItems.stream().map(mapper).collect(Collectors.toList());
        PageResult<R> result = new PageResult();
        result.setAllCount(this.getAllCount());
        result.setAllPages(this.allPages);
        result.setPageNum(this.pageNum);
        result.setPageSize(this.pageSize);
        result.setDataItems(collect);
        return result;
    }

    public PageResult() {
    }

    public long getAllCount() {
        return this.allCount;
    }

    public long getAllPages() {
        return this.allPages;
    }

    public long getPageNum() {
        return this.pageNum;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public List<T> getDataItems() {
        return this.dataItems;
    }

    public void setAllCount(long allCount) {
        this.allCount = allCount;
    }

    public void setAllPages(long allPages) {
        this.allPages = allPages;
    }

    public void setPageNum(long pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public void setDataItems(List<T> dataItems) {
        this.dataItems = dataItems;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof PageResult)) {
            return false;
        } else {
            PageResult<?> other = (PageResult)o;
            if (!other.canEqual(this)) {
                return false;
            } else if (this.getAllCount() != other.getAllCount()) {
                return false;
            } else if (this.getAllPages() != other.getAllPages()) {
                return false;
            } else if (this.getPageNum() != other.getPageNum()) {
                return false;
            } else if (this.getPageSize() != other.getPageSize()) {
                return false;
            } else {
                Object this$dataItems = this.getDataItems();
                Object other$dataItems = other.getDataItems();
                if (this$dataItems == null) {
                    if (other$dataItems != null) {
                        return false;
                    }
                } else if (!this$dataItems.equals(other$dataItems)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResult;
    }



    @Override
    public String toString() {
        return "PageResult(allCount=" + this.getAllCount() + ", allPages=" + this.getAllPages() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", dataItems=" + this.getDataItems() + ")";
    }
}
