package com.hikcreate.edl.pub.web.mobile.infra.core.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.concurrent.TimeUnit;

/**
 * 唯一建工具类
 *
 * @author lixian
 * @description
 * @date 2020/6/22 16:24
 **/
@Component
public class UnqIdUtil {
    @Autowired
    StringRedisTemplate redisTemplate;


    String redisKey = "park:unqid:random";

    public static void main( String[] args ) {
        long random = 11114432543l;
        random = random % 10000000;
        System.out.println(StrUtil.fillBefore(String.valueOf(random), '0', 8));
    }

    /**
     * 获取唯一建
     * 16（日期）+8（随机数）
     *
     * @return
     */
    public String getUnqId() {
        String id = "";
        id = id.concat(DateUtil.format(new Date(), DatePattern.PURE_DATETIME_MS_FORMAT));
        long random = redisTemplate.opsForValue().increment(redisKey, 1);
        if( random==1 ) {
            redisTemplate.expire(redisKey, 60l, TimeUnit.SECONDS);
        }
        random = random % 10000000;
        id = id.concat(StrUtil.fillBefore(String.valueOf(random), '0', 8));
        System.out.println("id:"+id);
        return id;
    }
}
