package com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms;

import com.hikcreate.edl.pub.web.mobile.infra.core.Result.Result;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.CheckVerifyCodeMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.SendMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.SendVerifyCodeMicReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 短信feign
 */
@FeignClient( name = "edl-pvt-service-common", path = "sms" )
public interface SmsFeign {

    @PostMapping( {"send"} )
    Result<Void> send( @RequestBody SendMicReq req );

    @PostMapping( {"verifyCode/send"} )
    Result<Void> sendVerifyCode( @RequestBody SendVerifyCodeMicReq req );

    @PostMapping( {"verifyCode/check"} )
    Result<Void> checkVerifyCode( @RequestBody CheckVerifyCodeMicReq req );
}