package com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense;

import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.request.CreditIdCardMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.request.IdCardMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.response.DlQrRes;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.response.DrivingLicenseMicRes;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 驾照调用
 *
 * @author MOUBK
 * @create 2019/4/9 19:49
 */
@FeignClient(value = "edl-pvt-service-dl", path = "drivingLicense")
public interface DrivingLicenseFeign {

    @PostMapping("getByIdCard")
    Response<DrivingLicenseMicRes> getByIdCard(@RequestBody CreditIdCardMicReq req);

    @PostMapping("/qr/getQrInfo")
    Response<DlQrRes> getQrInfo(@RequestBody @Validated IdCardMicReq req);
}
