package com.hikcreate.edl.pub.web.mobile.infra.model.param.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @author lixian
 * @description
 * @date 2020/6/22 14:12
 **/
@Data
public class BindInfoReq {
    /**
     * 客户id
     */
    @NotBlank(message = "客户唯一编码不能为空")
    private String userId;
    /**
     * 客户电话号码
     */
    @NotBlank(message = "客户手机号不能为空")
    @Pattern(regexp = "^(1)\\d{10}$", message = "客户手机号无效")
    private String phone;
    /**
     * 车主手机号码
     */
    @NotBlank(message = "车主手机号不能为空")
    @Pattern(regexp = "^(1)\\d{10}$", message = "车主手机号无效")
    private String ownerPhone;
    /**
     * 车牌颜色:A:白,B:灰,C:黄,D:粉,E:红,
     * F:紫,G:绿,H:蓝,I:棕,J:黑',
     */
    @NotBlank(message = "车牌颜色不能为空")
    @Pattern(regexp = "[ABCDEFGHIJ]", message = "车牌颜色不正确")
    private String plateColor;
    /**
     * 车牌号
     */
    @NotBlank(message = "车牌号不能为空")
    private String plateNum;

    /**
     * 时间戳
     */
    @NotNull(message = "时间戳不能为空")
    private Long timestamp;
}
