package com.hikcreate.edl.pub.web.mobile.infra.model.param.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author lixian
 * @description
 * @date 2020/7/20 17:09
 **/
@Data
public class BindSmsValidReq {
    /**
     * 客户电话号码
     */
    @NotBlank(message = "客户手机号不能为空")
    private String phone;
    /**
     * 车主手机号码
     */
    @NotBlank(message = "车主手机号不能为空")
    @Size(max = 11, message = "车主手机号无效")
    private String ownerPhone;
    /**
     * 验证码
     */
    @NotBlank(message = "验证码不能为空")
    private String smsCode;
    /**
     * 时间戳
     */
    @NotNull(message = "时间戳不能为空")
    private Long timestamp;
}
