-- auto-generated definition
create table bind_info
(
    unq_id        varchar(36)             not null comment '用户车辆绑定记录唯一编号'
        primary key,
    user_id       varchar(128)            not null comment '客户唯一编号',
    phone         varchar(11)             not null comment '客户手机号',
    plate_color   varchar(2)              null comment '车牌颜色:A:白,B:灰,C:黄,D:粉,E:红,F:紫,G:绿,H:蓝,I:棕,J:黑',
    plate_num     varchar(20)             not null comment '车主车牌号',
    plate_type    varchar(20)             not null comment '车牌类型',
    status        varchar(10) default '1' null comment '绑定状态:0,未绑定,1,已绑定',
    gmt_bind_time datetime                null comment '绑定时间',
    unbind_time   datetime                null comment '解绑时间',
    constraint bind_info_pk
        unique (user_id, unbind_time)
)
    comment '用户车辆绑定信息';

