package com.hikcreate.edl.pub.web.mobile.infra.data.cache;

import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.ViolationFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.ViolationPlateNumAndTypeQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.response.ViolationRes;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lixian
 * @description
 * @date 2020/6/21 16:46
 **/
@Component
public class ViolationCache {
    @Resource
    ViolationFeign violatio;

    /**
     * 查询违法数据
     *
     * @param req 号牌+号牌类型，时间开始-结束
     * @return
     */
    @Cacheable(value = "violations", key = "'plateNum:'+#req.plateNum+':plateType:'+#req.plateType+':timeStart:'+#req" +
            ".timeStart.toString()+':timeEnd:'+#req.timeEnd.toString()", unless = "#result==null or #result.size()==0")
    public List<ViolationRes> getByPlateNumAndType(ViolationPlateNumAndTypeQueryReq req) {
        return violatio.getByPlateNumAndType(req);
    }
}
