package com.hikcreate.edl.pub.web.mobile.api;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import com.ctrip.framework.apollo.spring.annotation.EnableApolloConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;

@SpringBootApplication(scanBasePackages = "com.hikcreate.edl.pub.web.mobile",exclude = DruidDataSourceAutoConfigure.class)
@MapperScan(basePackages = "com.hikcreate.edl.pub.web.mobile.infra.data.mapper")
@EnableDiscoveryClient
@EnableFeignClients("com.hikcreate")
@EnableEurekaClient
@EnableApolloConfig
@EnableCaching
public class ApiApplication {

    public static void main(String[] args) {
        SpringApplication.run(ApiApplication.class, args);
    }

}
