package com.hikcreate.edl.pub.web.mobile.api.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.common.sdk.response.statuscode.StatusCode;
import com.hikcreate.edl.common.sdk.util.VerifyCodeUtil;
import com.hikcreate.edl.pub.web.mobile.domain.IBindService;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result;
import com.hikcreate.edl.pub.web.mobile.infra.core.enums.ResultCode;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.SmsFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.CheckVerifyCodeMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.SendVerifyCodeMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.mapper.VerifyInfoMapper;
import com.hikcreate.edl.pub.web.mobile.infra.model.BindInfoQuery;
import com.hikcreate.edl.pub.web.mobile.infra.model.VerifyInfo;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.DrivingLicenseInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.InsuranceInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ResultList;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ViolationInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.YearCheckInfoRes;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


/**
 * 对外提供给H5的接口
 *
 * @menu H5接口
 * @author: xieshixiang
 * @time：2020/6/19 16:37
 **/
@RestController
@RequestMapping("/vehicle")
@Slf4j
public class H5Controller {

    @Autowired
    IBindService service;
    @Resource
    VerifyInfoMapper verifyInfoMapper;
    @Resource
    SmsFeign smsFeign;

    /**
     * 年检信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:32
     */
    @GetMapping("yearCheckInfo")
    public Response<YearCheckInfoRes> yearCheckInfo(@RequestBody @Validated BindInfoQuery query) {
        if (query == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        return service.yearCheckInfo(query);
    }

    /**
     * 违法信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:28
     */
    @GetMapping("violationInfo")
    public Response<ResultList<ViolationInfoRes>> violationInfo(@RequestBody @Validated BindInfoQuery query) {
        if (query == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        return service.violationInfo(query);
    }

    /**
     * 保险信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:28
     */
    @GetMapping("insuranceInfo")
    public Response<InsuranceInfoRes> insuranceInfo(@RequestBody @Validated BindInfoQuery query) {
        if (query == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        return service.insuranceInfo(query);
    }

    /**
     * 驾照信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:28
     */
    @GetMapping("drivingLicenseInfo")
    public Response<DrivingLicenseInfoRes> drivingLicenseInfo(@RequestBody BindInfoQuery query) {
        if (query == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        return service.drivingLicenseInfo(query);
    }

    @GetMapping("checkValidity")
    public Response checkValidity(@RequestBody BindInfoQuery query) {
        if (query == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        VerifyInfo verifyInfo = verifyInfoMapper.checkValidity(query.getPhone(), query.getUserId(),
                DateUtil.offsetDay(DateTime.now(), -10));

        if (verifyInfo != null) {
            return ResponseGenerator.success();
        } else {
            SendVerifyCodeMicReq sendVerifyCodeMicReq = new SendVerifyCodeMicReq();
            sendVerifyCodeMicReq.setUserId(query.getUserId());
            sendVerifyCodeMicReq.setPhone(query.getPhone());
            sendVerifyCodeMicReq.setVerifyCode(VerifyCodeUtil.getCode());
            return ResponseGenerator.fail(StatusCode.PERMISSION_DENIED.getCode(), null, sendVerifyCodeMicReq);
        }

    }

    @PostMapping("sendVerifyCode")
    public Response sendVerifyCode(@RequestBody SendVerifyCodeMicReq req) {
        if (req == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        return ResponseGenerator.success(smsFeign.sendVerifyCode(req));
    }

    @PostMapping("checkVerifyCode")
    public Response sendVerifyCode(@RequestBody CheckVerifyCodeMicReq req) {
        if (req == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }

        Result<Void> checkResult = smsFeign.checkVerifyCode(req);
        if (ResultCode.SUCCESS.getCode().equals(checkResult.getCode())) {
            VerifyInfo verifyInfo = new VerifyInfo();
            verifyInfo.setUserId(req.getUserId());
            verifyInfo.setVerifyCode(req.getVerifyCode());
            verifyInfo.setPhone(req.getPhone());
            verifyInfo.setPassTime(DateTime.now().toString());
            verifyInfoMapper.insert(verifyInfo);
        }
        return ResponseGenerator.success(checkResult);
    }


}
