package com.hikcreate.edl.pub.web.mobile.api.exception;

import com.hikcreate.common.sdk.exception.DefaultExceptionHandler;
import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.common.sdk.response.statuscode.StatusCode;
import feign.RetryableException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

/**
 * 全局异常处理类 FOR controller层以下的异常，Filter的异常不能捕获
 */
@Slf4j
@ControllerAdvice
public class GlobalExceptionHandler extends DefaultExceptionHandler {

    @Override
    @ExceptionHandler(value = ServletRequestBindingException.class)
    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    public Response handleServletRequestBindingException(ServletRequestBindingException e) {
        log.error("param bind failure", e);
        return ResponseGenerator.fail(StatusCode.PARAM_ERROR.getCode(), e.getMessage());
    }

    /**
     * 参数验证失败
     * <p>
     * GET 方法入口
     *
     * @param e
     * @return
     */
    @ExceptionHandler(ConstraintViolationException.class)
    @ResponseBody
    @ResponseStatus(HttpStatus.OK)
    public Response handleValidationException(ConstraintViolationException e) {
        for (ConstraintViolation<?> s : e.getConstraintViolations()) {
            log.error("Request parameter is invalid {}", s.getMessage());
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR.getCode(), s.getMessage());
        }
        return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
    }

    @ExceptionHandler(value = RetryableException.class)
    @ResponseBody
    public Response retryableExceptionHandler(HttpServletRequest req, RetryableException e) throws Exception {
        log.error(" connect timed out", e);
        return ResponseGenerator.fail(StatusCode.SYSTEM_ERROR.getCode(), "服务请求超时或不可用", e.getMessage());
    }
}