package com.hikcreate.edl.pub.web.mobile.api.intercept;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hikcreate.edl.common.sdk.util.EncryptStringAes;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.ResponseEncryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.enums.ResultCode;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.BaseEncryptRes;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * 返回加密拦截器
 * 返回对象必须为com.hikcreate.edl.pub.web.mobile.infra.core.Result类型
 * 加密后信息保存于Result.data
 * @author lixian
 * @description
 * @date 2020/6/19 10:39
 **/
@Slf4j
@ControllerAdvice
public class EncryptResponseBodyAdvice implements ResponseBodyAdvice {
    ObjectMapper objectMapper = new ObjectMapper();
    @Override
    public boolean supports( MethodParameter methodParameter, Class aClass ) {
        return true;
    }

    @Override
    public Object beforeBodyWrite( Object o, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse ) {
        try {
            log.info("Response body 明文: {}",objectMapper.writeValueAsString(o));
            if(methodParameter.getMethod().isAnnotationPresent(ResponseEncryptAnnotation.class) && o instanceof Result) {
                Result<Object> result= (Result<Object>)o;
                if( ResultCode.SUCCESS.getCode().equals(result.getCode()) ) {
                    //进行加密
                    Object data = result.getData();
                    if( data!=null ) {
                        String dataStr = objectMapper.writeValueAsString(data);
                        String encryptStr = EncryptStringAes.encryptAes(dataStr, "AES/ECB/PKCS5Padding");
                        BaseEncryptRes baseEncryptRes = new BaseEncryptRes();
                        baseEncryptRes.setEncData(encryptStr);
                        result.setData(baseEncryptRes);
                        o = result;
                        log.info("Response body 密文: {}",objectMapper.writeValueAsString(o));
                    }
                }
            }
        } catch ( Exception e ) {
            log.error("Response body 加密异常：{}", e);
        }
        return o;
    }
}
