package com.hikcreate.edl.pub.web.mobile.infra.core;

import com.hikcreate.edl.pub.web.mobile.infra.core.enums.ResultCode;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * description: 返回结果封装
 *
 * @author: xieshixiang
 * @time：2020/6/18 12:51
 **/
@Data
@NoArgsConstructor
public class Result<T> {

    private boolean success;
    private String msg;
    private String code;
    private T data;

    public static <T> Result<T> createResult(boolean isSuccess, String mes, T data, String code) {
        Result<T> result = new Result<T>();
        if (mes != null && !mes.isEmpty()) {
            result.setMsg(mes);
        }
        if (data != null) {
            result.setData(data);
        }
        result.setSuccess(isSuccess);
        result.setCode(code);
        return result;
    }

    public static <T> Result<T> createResult(ResultCode code, T data) {
        Result<T> result = new Result<T>();
        if (code.getMsg() != null && !code.getMsg().isEmpty()) {
            result.setMsg(code.getMsg());
        }

        if (data != null) {
            result.setData(data);
        }
        result.setSuccess(code.isSuccess());
        result.setCode(code.getCode());
        return result;
    }


    public static <T> Result<T> successResult() {
        return createResult(ResultCode.SUCCESS, null);
    }

    public static <T> Result<T> successResult(T data) {
        return createResult(ResultCode.SUCCESS, data);
    }

    public static <T> Result<T> errorResult() {
        return createResult(ResultCode.SYSTEM_UNKNOWN_ERROR, null);
    }

    public static <T> Result<T> errorResult(T data) {
        return createResult(ResultCode.SYSTEM_UNKNOWN_ERROR, data);
    }

    public static <T> Result<T> errorResult(ResultCode code) {
        return createResult(code, null);
    }


    public static <T> Result<T> errorResult(ResultCode code, T data) {
        return createResult(code, data);
    }


    public Result<T> failFast() {
        return this.failFast(this.code, this.msg);
    }

    public Result<T> failFast(String code, String msg) {
        if (!this.success) {
            RuntimeException ex = new RuntimeException(code + ":" + msg);
            throw ex;
        } else {
            return this;
        }
    }


    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof Result)) {
            return false;
        } else {
            Result<?> other = (Result) o;
            if (!other.canEqual(this)) {
                return false;
            } else if (this.isSuccess() != other.isSuccess()) {
                return false;
            } else {
                label49:
                {
                    Object this$message = this.getMsg();
                    Object other$message = other.getMsg();
                    if (this$message == null) {
                        if (other$message == null) {
                            break label49;
                        }
                    } else if (this$message.equals(other$message)) {
                        break label49;
                    }

                    return false;
                }

                Object this$code = this.getCode();
                Object other$code = other.getCode();
                if (this$code == null) {
                    if (other$code != null) {
                        return false;
                    }
                } else if (!this$code.equals(other$code)) {
                    return false;
                }

                Object this$data = this.getData();
                Object other$data = other.getData();
                if (this$data == null) {
                    if (other$data != null) {
                        return false;
                    }
                } else if (!this$data.equals(other$data)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Override
    public String toString() {
        return "Result(success=" + this.isSuccess() + ", message=" + this.getMsg() + ", code=" + this.getCode() + ", " +
                "data=" + this.getData() + ")";
    }
}
