package com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion;

import com.hikcreate.edl.pub.web.mobile.infra.core.constant.HttpHeaderConstants;
import com.hikcreate.edl.pub.web.mobile.infra.core.enums.DecryptModeEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 请求header解密注解
 * @author lixian
 * @description
 * @date 2020/6/19 10:02
 **/
@Retention( RetentionPolicy.RUNTIME)
@Target( ElementType.METHOD)
public @interface HeaderDecryptAnnotation {
    /**
     * 解密方式
     * @return
     */
    DecryptModeEnum mode() default DecryptModeEnum.AES;

    /**
     * 保存加密信息的header字段
     * @return
     */
    String header() default HttpHeaderConstants.HIK_ENC_DATA;
}
