package com.hikcreate.edl.pub.web.mobile.infra.core.page;

/**
 * 查询对象公共封装类
 *
 * @author: xieshixiang
 * @time：2020/6/18 16:17
 **/
public class PageQuery {
    /**
     * 当前页码
     */
    private int pageNum = 1;
    /**
     * 此次查询的数据条数
     */
    private int pageSize = 10;

    public PageQuery() {
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof PageQuery)) {
            return false;
        } else {
            PageQuery other = (PageQuery)o;
            if (!other.canEqual(this)) {
                return false;
            } else if (this.getPageNum() != other.getPageNum()) {
                return false;
            } else {
                return this.getPageSize() == other.getPageSize();
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageQuery;
    }



    @Override
    public String toString() {
        return "PageQuery(pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ")";
    }
}
