package com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle;

import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.PlateNumAndTypeQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.PlateNumQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.response.VehicleRes;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import java.util.List;

/**
 * @author: xieshixiang
 * @time：2020/6/19 14:26
 **/
@FeignClient(value = "dcp-service-vem", path = "vehicle",contextId = "dcp-service-vem-vehicle")
public interface VechicleFeign {

    /**
     * -----获取车辆信息列表------
     *
     * @param req
     * @return
     * @param号牌号码
     */
    @PostMapping("/getByPlateNum")
    List<VehicleRes> getByPlateNum(@RequestBody PlateNumQueryReq req);

    /**
     * -----获取车辆信息------
     * 查询车辆信息-号牌号码和号牌类型
     *
     * @param req
     * @return
     * @param号牌号码
     * @param号牌类型
     */
    @PostMapping("/getByPlateNumAndType")
    VehicleRes getByPlateNumAndType(@RequestBody PlateNumAndTypeQueryReq req);
}
