package com.hikcreate.edl.pub.web.mobile.api.controller;

import com.hikcreate.common.orika.DefaultConverter;
import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.edl.pub.web.mobile.domain.IBindService;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.BodyDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.ResponseEncryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.model.entity.ParkBindInfo;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindInfoQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindInfoReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.UnBindReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.BindInfoQueryRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.BindInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ResultList;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 绑定信息的controller
 *
 * @menu 提供给第三方接口
 * @author: xieshixiang
 * @time：2020/6/18 15:59
 **/
@RestController
@RequestMapping("/vehicle")
@Slf4j
public class BindInfoControlller extends BaseController {

    @Autowired
    IBindService service;
    @Autowired
    DefaultConverter defaultConverter;


    /**
     * 绑定用户信息的接口
     *
     * @param req
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:27
     */
    @PostMapping("bind")
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Response<BindInfoRes> bindInfo(@RequestBody @Validated BindInfoReq req) {
        ParkBindInfo bindInfo = new ParkBindInfo();
        defaultConverter.getMapperFacade().map(req, bindInfo);
        return service.bind(bindInfo);
    }


    /**
     * 解绑用户信息的接口
     *
     * @param req
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:27
     */
    @PostMapping("unbind")
    @BodyDecryptAnnotation
    public Response unbindInfo(@RequestBody @Validated UnBindReq req) {
        return service.unbindInfo(req) ? ResponseGenerator.success() : ResponseGenerator.fail("解绑失败");
    }

    /**
     * 绑定信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:31
     */
    @PostMapping("query")
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Response<ResultList<BindInfoQueryRes>> bindInfoQery(@RequestBody @Validated BindInfoQueryReq query) {
        return ResponseGenerator.success(new ResultList<BindInfoQueryRes>(service.selectByQuery(query)));
    }

}
