package com.hikcreate.edl.pub.web.mobile.api.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.hikcreate.common.orika.DefaultConverter;
import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.common.sdk.response.statuscode.StatusCode;
import com.hikcreate.edl.common.sdk.util.VerifyCodeUtil;
import com.hikcreate.edl.pub.web.mobile.domain.IBindService;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.HeaderDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.SmsFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.CheckVerifyCodeMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.SendVerifyCodeMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.mapper.VerifyInfoMapper;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.H5BindInfoQuery;
import com.hikcreate.edl.pub.web.mobile.infra.model.entity.ParkVerifyInfo;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.CheckVerifyCodeReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.SendVerifyCodeReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.CheckValidityRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.DrivingLicenseInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.InsuranceInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ResultList;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ViolationInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.YearCheckInfoRes;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


/**
 * 对外提供给H5的接口
 *
 * @menu H5接口
 * @author: xieshixiang
 * @time：2020/6/19 16:37
 **/
@RestController
@RequestMapping("/vehicle")
@Slf4j
public class H5Controller {

    @Autowired
    IBindService service;
    @Resource
    VerifyInfoMapper verifyInfoMapper;
    @Resource
    SmsFeign smsFeign;
    @Autowired
    DefaultConverter defaultConverter;

    /**
     * 年检信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:32
     */
    @PostMapping("yearCheckInfo")
    @HeaderDecryptAnnotation
    public Response<YearCheckInfoRes> yearCheckInfo(@RequestBody @Validated H5BindInfoQuery query) {

        return service.yearCheckInfo(query);
    }

    /**
     * 违法信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:28
     */
    @PostMapping("violationInfo")
    @HeaderDecryptAnnotation
    public Response<ResultList<ViolationInfoRes>> violationInfo(@RequestBody @Validated H5BindInfoQuery query) {

        return service.violationInfo(query);
    }

    /**
     * 保险信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:28
     */
    @PostMapping("insuranceInfo")
    @HeaderDecryptAnnotation
    public Response<InsuranceInfoRes> insuranceInfo(@RequestBody @Validated H5BindInfoQuery query) {

        return service.insuranceInfo(query);
    }

    /**
     * 驾照信息查询接口
     * header或body传值
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:28
     */
    @PostMapping("drivingLicenseInfo")
    @HeaderDecryptAnnotation
    public Response<DrivingLicenseInfoRes> drivingLicenseInfo(@RequestBody @Validated H5BindInfoQuery query) {

        return service.drivingLicenseInfo(query);
    }

    /**
     * 验证当前手机号是否在10天内,已通过验证
     * @param query
     * @return
     */
    @PostMapping("checkValidity")
    @HeaderDecryptAnnotation
    public Response<CheckValidityRes> checkValidity( @RequestBody @Validated H5BindInfoQuery query) {

        ParkVerifyInfo verifyInfo = verifyInfoMapper.checkValidity(query.getPhone(), query.getUserId(),
                DateUtil.offsetDay(DateTime.now(), -10));

        CheckValidityRes checkValidityRes = new CheckValidityRes();
        defaultConverter.getMapperFacade().map(query, checkValidityRes);
        if (verifyInfo != null) {
            checkValidityRes.setIsChecked(1);
        } else {
            checkValidityRes.setIsChecked(0);
        }
        return ResponseGenerator.success(checkValidityRes);
    }

    /***
     * 发送短信验证码
     *
     * @param req
     * @return Response
     * @author: xsx
     * @date: 2020/6/21 13:57
     */
    @PostMapping("sendVerifyCode")
    public Response<Void> sendVerifyCode(@RequestBody @Validated SendVerifyCodeReq req) {

        SendVerifyCodeMicReq micReq = new SendVerifyCodeMicReq();
        micReq.setPhone(req.getPhone());
        micReq.setVerifyCode(VerifyCodeUtil.getCode());
        micReq.setTemplateCode("PARK_LOOK_DRIVER_LICENSE");
        return smsFeign.sendVerifyCode(micReq);
    }

    /**
     * 校验短信验证码
     *
     * @param req
     * @return Response
     * @author: xsx
     * @date: 2020/6/21 13:58
     */
    @PostMapping("checkVerifyCode")
    public Response<Void> checkVerifyCode(@RequestBody @Validated CheckVerifyCodeReq req) {

        CheckVerifyCodeMicReq micReq = new CheckVerifyCodeMicReq();
        micReq.setPhone(req.getPhone());
        micReq.setVerifyCode(req.getVerifyCode());
        micReq.setTemplateCode("PARK_LOOK_DRIVER_LICENSE");

        Response<Void> checkResult = smsFeign.checkVerifyCode(micReq);
        if (StatusCode.SUCCESS.getCode() == (checkResult.getCode())) {
            ParkVerifyInfo verifyInfo = new ParkVerifyInfo();
            verifyInfo.setUserId(req.getUserId());
            verifyInfo.setVerifyCode(req.getVerifyCode());
            verifyInfo.setPhone(req.getPhone());
            verifyInfo.setPassTime(DateTime.now().toString());
            verifyInfoMapper.insert(verifyInfo);
        }
        return checkResult;
    }
}
