package com.hikcreate.edl.pub.web.mobile.infra.data.cache;

import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.DrivingLicenseFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.IdCardQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.response.DrivingLicenseRes;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 驾照信息缓存
 *
 * @author: xieshixiang
 * @time：2020/6/21 17:45
 **/
@Component
public class DrivingLicenseCache {

    @Resource
    DrivingLicenseFeign feign;

    @Cacheable(value = "drivingLicense", key = "'idCard:'+#req.idCard", unless = "#result==null")
    public DrivingLicenseRes getByIdCard(IdCardQueryReq req) {
        return feign.getByIdCard(req);
    }

}
