package com.hikcreate.edl.pub.web.mobile.infra.data.cache;

import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.VechicleFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.PlateNumAndTypeQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.PlateNumQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.response.VehicleRes;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lixian
 * @description
 * @date 2020/6/21 15:53
 **/
@Component
public class VechicleCache {

    @Resource
    private VechicleFeign vechicle;

    /**
     * -----获取车辆信息列表------
     *
     * @param req
     * @return
     * @param号牌号码
     */
    @Cacheable(value = "vehicles", key = "'plateNum:'+#req.plateNum", unless = "#result==null or #result.size()==0")
    public List<VehicleRes> getByPlateNum( @RequestBody PlateNumQueryReq req){
        return vechicle.getByPlateNum(req);
    }

    /**
     * -----获取车辆信息------
     * 查询车辆信息-号牌号码和号牌类型
     *
     * @param req
     * @return
     * @param号牌号码
     * @param号牌类型
     */
    @Cacheable(value = "vehicle", key = "'plateNum:'+#req.plateNum+':plateType:'+#req.plateType", unless = "#result==null")
    public VehicleRes getByPlateNumAndType(@RequestBody PlateNumAndTypeQueryReq req) {
        return vechicle.getByPlateNumAndType(req);
    }
}
