package com.hikcreate.edl.pub.web.mobile.api.controller;

import com.alibaba.fastjson.JSONObject;
import com.hikcreate.common.sdk.exception.BusinessException;
import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.common.sdk.response.statuscode.StatusCode;
import com.hikcreate.edl.common.image.builder.domain.DlBackImageDO;
import com.hikcreate.edl.common.image.builder.domain.DlImageDO;
import com.hikcreate.edl.pub.web.mobile.domain.CredentialsImageService;
import com.hikcreate.edl.pub.web.mobile.domain.DrivingLicenseService;
import com.hikcreate.edl.pub.web.mobile.domain.IBindService;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result.Result;
import com.hikcreate.edl.pub.web.mobile.infra.core.Result.ResultGenerator;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.HeaderDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.configbean.FastDfsConfigBean;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.DrivingLicenseFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.request.CreditIdCardMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pvt_service_drivinglicense.response.DrivingLicenseMicRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.DrivingLicenseValidReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.DrivingLicenseValidSmsCodeReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.DrivingLicenseInfoRes;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.DrivingLicenseValidRes;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;

/**
 * 驾驶证图片接口
 *
 * @author MOUBK
 * @menu
 * @create 2020/7/20 17:44
 **/
@RestController
@RequestMapping("/drivingLicense")
@Slf4j
public class DrivingLicenseController {

    @Autowired
    private CredentialsImageService credentialsImageService;
    @Autowired
    private DrivingLicenseFeign drivingLicenseFeign;
    @Autowired
    private FastDfsConfigBean fastDfsConfigBean;
    @Autowired
    private DrivingLicenseService drivingLicenseService;
    @Autowired
    private IBindService iBindService;

    @PostMapping("/valid")
    @HeaderDecryptAnnotation
    public Result<DrivingLicenseValidRes> valid(@RequestBody @Validated DrivingLicenseValidReq req) {
        DrivingLicenseValidRes drivingLicenseValidRes = drivingLicenseService.checkIdCard(req.getIdCard(), req.getUserId());
        return ResultGenerator.success(drivingLicenseValidRes);
    }

    @GetMapping("/sendSmsCode")
    public Result<Void> sendSmsCode(@RequestParam("userId") String userId) {
        drivingLicenseService.sendSmsCode(userId);
        return ResultGenerator.success();
    }

    @PostMapping("/validSmsCode")
    public Result<Void> validSmsCode(@RequestBody @Validated DrivingLicenseValidSmsCodeReq req) {
        drivingLicenseService.validSmsCode(req.getUserId(), req.getSmsCode());
        return ResultGenerator.success();
    }

    @GetMapping("/info")
    public Result<DrivingLicenseInfoRes> getDrivingLicenseInfo(@RequestParam("userId") String userId) {
        DrivingLicenseInfoRes drivingLicenseInfoRes = drivingLicenseService.getDrivingLicenseInfo(userId);
        return ResultGenerator.success(drivingLicenseInfoRes);
    }

    @GetMapping("/image")
    public void image(@RequestParam("userId") String userId, @RequestParam("idCard") String idCard, @RequestParam("type") Integer type, HttpServletResponse response) {
        // 验证是否有查看权限
        if (!drivingLicenseService.checkValid(userId, idCard) && !iBindService.checkValid(userId, idCard)) {
            throw new BusinessException(StatusCode.PARAM_ERROR);
        }
        DrivingLicenseMicRes drivingLicenseMicRes = drivingLicenseFeign.getByIdCard(new CreditIdCardMicReq().setIdCard(idCard)).fallback().getData();

        ByteArrayOutputStream outputStream;
        if (type == null || Objects.equals(type, 1)) {
            DlImageDO dlImageDO = new DlImageDO();
            dlImageDO.setAddress(drivingLicenseMicRes.getAddress());
            dlImageDO.setBelowLicenseNumber(drivingLicenseMicRes.getIdCard());
            dlImageDO.setAvatarFullUrl(fastDfsConfigBean.genBigDataInnerUrl(drivingLicenseMicRes.getAvatar()));
            dlImageDO.setBirthday(drivingLicenseMicRes.getBirthday());
            dlImageDO.setLicenseNumber(drivingLicenseMicRes.getIdCard());
            dlImageDO.setInitLicenseDate(drivingLicenseMicRes.getIssueDate());
            dlImageDO.setName(drivingLicenseMicRes.getRealName());
            dlImageDO.setBelowName(drivingLicenseMicRes.getRealName());
            dlImageDO.setModel(drivingLicenseMicRes.getLicenseType());
            dlImageDO.setNationality(drivingLicenseMicRes.getNationality());
            dlImageDO.setSex(drivingLicenseMicRes.getGender());
            dlImageDO.setValidityPeriod(drivingLicenseMicRes.getEffectiveDate() + "至" + drivingLicenseMicRes.getExpiryDate());
            dlImageDO.setRecord("");
            dlImageDO.setFileNumber(drivingLicenseMicRes.getFileNum());
            outputStream = (ByteArrayOutputStream) credentialsImageService.genDlImage(dlImageDO);
        } else {
            DlBackImageDO dlBackImageDO = new DlBackImageDO();
            dlBackImageDO.setRecordContents("");
            dlBackImageDO.setSerialNum("");
            outputStream = (ByteArrayOutputStream) credentialsImageService.genDlBackImage(dlBackImageDO);
        }
        try {
            setHeader(response, drivingLicenseMicRes.getIdCard() + ".jpg");
            response.getOutputStream().write(outputStream.toByteArray());
        } catch (Exception e) {
            log.error("Get dl img E, idCard={}, userId={}, msg={}", idCard, userId, e);
            getResException(response, "获取驾照图片异常");
        } finally {
            try {
                if (null != outputStream) {
                    outputStream.close();
                }
            } catch (Exception e) {
                log.error("Get dl img IOE, msg={}", e);
            }
        }

    }

    private void getResException(HttpServletResponse response, String msg) {
        try {
            Response<Void> res = ResponseGenerator.fail(StatusCode.SYSTEM_ERROR, msg);
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JSONObject.toJSONString(res));
        } catch (IOException e) {
            log.error("Get dl header IOE, msg={}", e);
        }
    }

    private void setHeader(HttpServletResponse resposne, String fileName) {
        resposne.setDateHeader("Expires", 0L);
        resposne.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resposne.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resposne.setHeader("Pragma", "no-cache");
        resposne.setContentType("image/jpeg");
        resposne.setHeader("Content-Disposition", "attachment;filename=" + fileName);
    }
}
