package com.hikcreate.edl.pub.web.mobile.api.controller;

import com.hikcreate.edl.common.sdk.util.EncryptStringAes;
import com.hikcreate.edl.pub.web.mobile.infra.core.configbean.SignKeyConfigBean;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工具
 *
 * @author lixian
 * @menu 工具类
 * @description
 * @date 2020/6/18 17:57
 **/
@Slf4j
@RestController
@RequestMapping("/tool")
public class ToolController {
    @Autowired
    SignKeyConfigBean signKeyConfigBean;

    /**
     * 加密
     *
     * @param plain 明文
     * @return
     */
    @GetMapping(value = "encrypt")
    public String encrypt(String plain) {
        return EncryptStringAes.encryptAes(plain, signKeyConfigBean.getKey());
    }

    /**
     * 解密
     *
     * @param cipher 密文
     * @return
     */
    @GetMapping(value = "decrypt")
    public String decrypt(String cipher) {
        return EncryptStringAes.decryptAes(cipher, signKeyConfigBean.getKey());
    }

    /**
     * 获取时间戳
     *
     * @return
     */
    @GetMapping(value = "timestamp")
    public String timestamp() {
        return String.valueOf(System.currentTimeMillis());
    }
}
