package com.hikcreate.edl.pub.web.mobile.infra.core.Result;

import com.hikcreate.common.sdk.response.statuscode.IStatusCode;
import com.hikcreate.common.sdk.response.statuscode.StatusCode;

/**
 *
 */
public class ResultGenerator {

    public static <T> Result<T> success() {
        return new Result<>();
    }

    public static <T> Result<T> success(String msg, T data) {
        Result<T> result = new Result<>();
        result.setMsg(msg);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<>();
        result.setData(data);
        return result;
    }

    public static <T> Result<T> success4Msg(String msg) {
        Result<T> result = new Result<>();
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> fail(String msg) {
        Result<T> result = new Result<>();
        result.setSuccess(false);
        result.setCode(StatusCode.BUSINESS_ERROR.getCode());
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> fail( IStatusCode statusCode) {
        Result<T> result = new Result<>();
        result.setSuccess(false);
        result.setCode(statusCode.getCode());
        result.setMsg(statusCode.getMsg());
        return result;
    }


    public static <T> Result<T> fail(long code, String msg) {
        Result<T> result = new Result<>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> fail(long code, String msg, T data) {
        Result<T> result = new Result<>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMsg(msg);
        result.setData(data);
        return result;
    }


    public static <T> Result<T> copy(Result<?> from) {
        Result<T> result = new Result<>();
        result.setSuccess(from.isSuccess());
        result.setCode(from.getCode());
        result.setMsg(from.getMsg());
        return result;
    }
}
