package com.hikcreate.edl.pub.web.mobile.infra.data.cache;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.hikcreate.edl.pub.web.mobile.infra.data.mapper.BindInfoMapper;
import com.hikcreate.edl.pub.web.mobile.infra.model.entity.ParkBindInfo;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * @author lixian
 * @description
 * @date 2020/6/21 15:49
 **/
@Component
public class BindCache {
    @Resource
    private BindInfoMapper mapper;


    @Caching(evict = {
            @CacheEvict(value = "bindinfo", key = "'userId:'+#info.userId", condition = "#info!=null")
    })
    public boolean insert(ParkBindInfo info) {
        return mapper.insert(info) > 0;
    }


    /**
     * 获取绑定信息
     *
     * @param unqId
     * @return
     */
    @Cacheable(value = "bindinfo", key = "'id:'+#unqId", unless = "#result==null")
    public ParkBindInfo getById(String unqId) {
        LambdaQueryWrapper<ParkBindInfo> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ParkBindInfo::getUnqId, unqId);
        queryWrapper.eq(ParkBindInfo::getStatus, 1);
        return mapper.selectOne(queryWrapper);
    }

    /**
     * 查询用户绑定信息
     *
     * @param userId 第三方用户ID
     * @return
     */
    @Cacheable(value = "bindinfo", key = "'userId:'+#userId", unless = "#result==null or #result.size()==0")
    public List<ParkBindInfo> selectByQuery(String userId) {
        return mapper.selectByQuery(userId);
    }

    /**
     * 解绑
     *
     * @param unqId  绑定唯一标识
     * @param userId 第三方用户ID
     * @return
     */
    @Caching(evict = {
            @CacheEvict(value = "bindinfo", key = "'id:'+#unqId", condition = "#unqId!=null"),
            @CacheEvict(value = "bindinfo", key = "'userId:'+#userId", condition = "#userId!=null")
    })
    public boolean unBind(String unqId, String userId) {
        ParkBindInfo bindInfo = new ParkBindInfo();
        bindInfo.setUnqId(unqId);
        bindInfo.setUserId(userId);
        bindInfo.setStatus("0");
        bindInfo.setUnbindTime(new Date());
        return mapper.unbind(bindInfo) > 0;
    }


}
