package com.hikcreate.edl.pub.web.mobile.infra.data.cache;

import com.hikcreate.edl.pub.web.mobile.infra.data.feign.pvt_service_traffic.parm.ViolationFeign;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.pvt_service_traffic.parm.request.ViolationListByTimeReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.pvt_service_traffic.parm.response.ViolationMicRes;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author lixian
 * @description
 * @date 2020/6/21 16:46
 **/
@Component
public class ViolationCache {
    @Resource
    ViolationFeign violatio;

    /**
     * 查询违法数据
     *
     * @param req 号牌+号牌类型，时间开始-结束
     * @return
     */
//    @Cacheable(value = "violations", key = "'plateNum:'+#req.plateNum+':plateType:'+#req.plateType", unless = "#result==null or #result.size()==0")
    public List<ViolationMicRes> getByPlateNumAndType(ViolationListByTimeReq req) {
        return violatio.listByTime(req).fallback().getData();
    }
}
