package com.hikcreate.edl.pub.web.mobile.infra.model.param.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author lixian
 * @description
 * @date 2020/7/20 18:19
 **/
@Data
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class AdminUnbindReq {
    /**
     * 客户id
     */
    @NotBlank(message = "客户唯一编码不能为空")
    private String userId;
    /**
     * 用户车辆绑定唯一编号
     */
    @NotBlank(message = "用户车辆绑定唯一编号不能为空")
    private String unqId;
    /**
     * 时间戳
     */
    @NotNull(message = "时间戳不能为空")
    private Long timestamp;
}
