package com.hikcreate.edl.pub.web.mobile.infra.core.enums;

/**
 * description: 请求返回的结果的code码
 *
 * @author: xieshixiang
 * @time：2020/6/18 12:38
 **/

public enum ResultCode {

    SUCCESS("1000", "操作成功", true),
    SYSTEM_UNKNOWN_ERROR("1001", "系统未知错误", false),
    HASH_NO_PRIVILEGE("1002", "没有权限访问该服务", false),
    DATA_ERROR("1003", "数据错误", false),
    RESUBMIT("1004", "重复提交", false),
    PARAMETER_ERROR("1005", "参数错误", false),
    SERVICE_ERROR("1006", "业务错误", false);

    private String code;
    private String msg;
    private boolean success;

    ResultCode(String code, String msg, boolean success) {
        this.code = code;
        this.msg = msg;
        this.success = success;
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return msg;
    }

    public boolean isSuccess() {
        return success;
    }
}
