package com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle;

import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.ViolationIdCardQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.request.ViolationPlateNumAndTypeQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.dcp_service_vehicle.param.response.ViolationRes;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 违法信息查询远程调用
 *
 * @author: xieshixiang
 * @time：2020/6/19 15:26
 **/
@FeignClient(url = "http://10.197.236.100:40204",name = "dcp-service-vehicle", path = "violation",contextId ="dcp" +
        "-service-vehicle-violation")
public interface ViolationFeign {

    /**
     * 查询违法数据
     *
     * @param req 身份证号，时间开始-结束
     * @return
     */
    @PostMapping("/getByIdCard")
    List<ViolationRes> getByIdCard(@RequestBody ViolationIdCardQueryReq req);

    /**
     * 查询违法数据
     *
     * @param req 号牌+号牌类型，时间开始-结束
     * @return
     */
    @PostMapping("/getByPlateNumAndType")
    List<ViolationRes> getByPlateNumAndType(@RequestBody ViolationPlateNumAndTypeQueryReq req);


}
