package com.hikcreate.edl.pub.web.mobile.api.controller;

import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.common.sdk.response.statuscode.StatusCode;
import com.hikcreate.edl.pub.web.mobile.domain.IBindService;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.BodyDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.ResponseEncryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.data.mapper.BindInfoMapper;
import com.hikcreate.edl.pub.web.mobile.infra.model.BindInfo;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindInfoQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.UnBindReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.ResultList;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 绑定信息的controller
 *
 * @menu 提供给第三方接口
 * @author: xieshixiang
 * @time：2020/6/18 15:59
 **/
@RestController
@RequestMapping("/vehicle")
@Slf4j
public class BindInfoControlller extends BaseController {

    @Autowired
    IBindService service;
    @Resource
    BindInfoMapper mapper;


    /**
     * 绑定用户信息的接口
     *
     * @param info
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:27
     */
    @PostMapping("bind")
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Response<String> bindInfo(@RequestBody BindInfo info) {
        if (info == null) {
            return ResponseGenerator.fail(StatusCode.PARAM_ERROR);
        }
        return service.bind(info);
    }


    /**
     * 解绑用户信息的接口
     *
     * @param req
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:27
     */
    @PostMapping("unbind")
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Response unbindInfo(@RequestBody @Validated UnBindReq req) {
        return service.unbindInfo(req) ? ResponseGenerator.success() : ResponseGenerator.fail("解绑失败");
    }

    /**
     * 绑定信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:31
     */
    @PostMapping("query")
    @BodyDecryptAnnotation
    @ResponseEncryptAnnotation
    public Response<ResultList<BindInfo>> bindInfoQery(@RequestBody @Validated BindInfoQueryReq query) {
        return ResponseGenerator.success(new ResultList<BindInfo>(service.selectByQuery(query)));
    }

}
