package com.hikcreate.edl.pub.web.mobile.api.controller;

import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.common.sdk.response.apiparam.ResponseGenerator;
import com.hikcreate.edl.common.sdk.util.EncryptStringAes;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.BodyDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.HeaderDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.ResponseEncryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.configbean.SignKeyConfigBean;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.TestRes;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author lixian
 * @description
 * @date 2020/6/18 17:57
 **/
@Slf4j
@RestController
@RequestMapping("/test")
public class TestController {
    @Autowired
    SignKeyConfigBean signKeyConfigBean;

    @GetMapping(value = "encrypt")
    public String encrypt( String plain) {
      return EncryptStringAes.encryptAes(plain, signKeyConfigBean.getKey());
    }

}
