package com.hikcreate.edl.pub.web.mobile.api.intercept;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hikcreate.edl.common.sdk.util.EncryptStringAes;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.BodyDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.annotatiion.HeaderDecryptAnnotation;
import com.hikcreate.edl.pub.web.mobile.infra.core.configbean.SignKeyConfigBean;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BaseEncryptReq;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;


/**
 * 请求解密拦截器
 *
 * @author lixian
 * @description
 * @date 2020/6/18 17:32
 **/
@Slf4j
@ControllerAdvice
public class DecryptRequestBodyAdvice implements RequestBodyAdvice {
    @Autowired
    SignKeyConfigBean signKeyConfigBean;

    ObjectMapper objectMapper = new ObjectMapper();



    @Override
    public boolean supports( MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass ) {
        return true;
    }

    @Override
    public HttpInputMessage beforeBodyRead( HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass ) throws IOException {
        XHttpInputMessage xHttpInputMessage = new XHttpInputMessage(httpInputMessage, methodParameter, signKeyConfigBean.getKey());

        return xHttpInputMessage;
        /*return new HttpInputMessage() {
            @Override
            public InputStream getBody() throws IOException {
                String bodyStr = IOUtils.toString(httpInputMessage.getBody());
                log.info("Request Body encrypt：{}",bodyStr);
                BaseEncryptReq encryptReq = objectMapper.readValue(bodyStr, BaseEncryptReq.class);
                String decryptStr = EncryptStringAes.decryptAes(encryptReq.getEncData(), "AES/ECB/PKCS5Padding");
                return IOUtils.toInputStream(decryptStr, "utf-8");
            }
            @Override
            public HttpHeaders getHeaders() {
                return httpInputMessage.getHeaders();
            }
        };*/
    }

    @Override
    public Object afterBodyRead( Object o, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass ) {
        try {
            log.info("Request Body 明文: " + objectMapper.writeValueAsString(o));
        } catch ( Exception e ) {
            e.printStackTrace();
        }
        return o;
    }

    @Override
    public Object handleEmptyBody( Object o, HttpInputMessage httpInputMessage, MethodParameter methodParameter, Type type, Class<? extends HttpMessageConverter<?>> aClass ) {
        return o;
    }

    //这里实现了HttpInputMessage 封装一个自己的HttpInputMessage
    public static class XHttpInputMessage implements HttpInputMessage {
        private HttpHeaders headers;
        private InputStream body;
        private MethodParameter methodParameter;
        private String key;

        public XHttpInputMessage( HttpInputMessage httpInputMessage, MethodParameter methodParameter, String key ) throws IOException {
            this.headers = httpInputMessage.getHeaders();
            this.body = httpInputMessage.getBody();
            this.methodParameter = methodParameter;
            this.key = key;
            //解密请求数据
            decrypt();
        }

        /**
         * 解密请求数据
         */
        private void decrypt() {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String encryptStr = null;
                if ( this.methodParameter.getMethod().isAnnotationPresent(BodyDecryptAnnotation.class) ) {
                    String bodyStr = IOUtils.toString(this.body);
                    log.info("Request Body 密文：{}", bodyStr);
                    BaseEncryptReq encryptReq = objectMapper.readValue(bodyStr, BaseEncryptReq.class);
                    encryptStr = encryptReq.getEncData();
                } else if ( this.methodParameter.getMethod().isAnnotationPresent(HeaderDecryptAnnotation.class) ) {
                    HeaderDecryptAnnotation annotation = this.methodParameter.getMethodAnnotation(HeaderDecryptAnnotation.class);
                    encryptStr = this.headers.getFirst(annotation.header());
                    log.info("Request Header 密文：{}", encryptStr);
                }
                if ( StrUtil.isNotBlank(encryptStr) ) {
                    //解密
                    String decryptStr = EncryptStringAes.decryptAes(encryptStr, key );
                    this.body = IOUtils.toInputStream(decryptStr, "utf-8");
                }
            } catch ( Exception e ) {
                log.error("Request Body 解密异常：{}", e);
            }
        }

        @Override
        public InputStream getBody() {
            return body;
        }

        @Override
        public HttpHeaders getHeaders() {
            return headers;
        }
    }
}


