package com.hikcreate.edl.pub.web.mobile.domain;

import com.baomidou.mybatisplus.extension.service.IService;
import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.edl.pub.web.mobile.infra.model.BindInfo;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.BindInfoQueryReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.H5BindInfoQuery;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.request.UnBindReq;
import com.hikcreate.edl.pub.web.mobile.infra.model.param.response.DrivingLicenseInfoRes;

import java.util.List;


/**
 * 客户绑定服务接口
 *
 * @author: xieshixiang
 * @time：2020/6/18 16:11
 **/
public interface IBindService extends IService<BindInfo> {

    /**
     * 信息绑定接口
     *
     * @param info
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 10:32
     */
    Response bind( BindInfo info);

    /**
     * 信息解绑
     * @param req
     * @return
     */
    boolean unbindInfo( UnBindReq req );

    /**
     * 查询用户绑定信息
     * @param query
     * @return
     */
    List<BindInfo> selectByQuery( BindInfoQueryReq query);

    /**
     * 年检信息查询接口
     *
     * @param query
     * @return
     */
    Response yearCheckInfo( H5BindInfoQuery query);

    /**
     * 保险信息查询接口
     * @param query
     * @return
     */
    Response insuranceInfo( H5BindInfoQuery query);

    /**
     * 违法信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:06
     */
    Response violationInfo( H5BindInfoQuery query);

    /**
     * 驾照信息查询接口
     *
     * @param query
     * @return Result
     * @author: xsx
     * @date: 2020/6/19 16:29
     */
    Response<DrivingLicenseInfoRes> drivingLicenseInfo( H5BindInfoQuery query);

}
