package com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms;

import com.hikcreate.common.sdk.response.apiparam.Response;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.CheckVerifyCodeMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.SendMicReq;
import com.hikcreate.edl.pub.web.mobile.infra.data.feign.edl_pub_service_sms.param.request.SendVerifyCodeMicReq;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 短信feign
 */
@FeignClient( name = "edl-pvt-service-common",path = "sms" )
public interface SmsFeign {

    @PostMapping( {"send"} )
    Response<Void> send( @RequestBody SendMicReq req );

    @PostMapping( {"verifyCode/send"} )
    Response<Void> sendVerifyCode( @RequestBody SendVerifyCodeMicReq req );

    @PostMapping( {"verifyCode/check"} )
    Response<Void> checkVerifyCode( @RequestBody CheckVerifyCodeMicReq req );
}