package com.hikcreate.update_hbase.aspect;

import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

/**
 * Created by lifuyi on 2018/10/24.
 */
public class DynamicDataSource extends AbstractRoutingDataSource {
    //保存自己线程的本地变量
    private static final ThreadLocal<String> datasourceHolder = new ThreadLocal<>();

    @Override
    protected Object determineCurrentLookupKey() {
        return datasourceHolder.get();
    }

    static void setDataSource(String sourceName) {
        datasourceHolder.set(sourceName);
    }

    static void clearDataSource() {
        datasourceHolder.remove();
    }
}
