package com.hikcreate.update_hbase.aspect;



import com.hikcreate.update_hbase.annotation.DBSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * Created by lifuyi on 2018/10/24.
 */
@Aspect
@Order(-1)// 保证该AOP在@Transactional之前执行
@Component
public class DynamicDataSourceAspect {

    @Before(value = "execution(* com.hikcreate.update_hbase.dao..*.*(..))")
    public void changeDataSource(JoinPoint point) throws Throwable {
        String sourceName = null;
        //获得当前访问的class
        Class<?> classes = point.getTarget().getClass();
        //获得访问的方法名称
        String methodName = point.getSignature().getName();
        //定义的接口方法
        Method abstractMethod = ((MethodSignature) point.getSignature()).getMethod();
        //是否含有注解DBSource
        if (abstractMethod.isAnnotationPresent(DBSource.class)) {
            sourceName = abstractMethod.getAnnotation(DBSource.class).name();
        }
        //接口方法参数类型
        Class<?>[] parameterTypes = abstractMethod.getParameterTypes();
        try {
            //实现类中的该方法
            Method method = classes.getMethod(methodName, parameterTypes);
            if (method.isAnnotationPresent(DBSource.class)) {
                sourceName = method.getAnnotation(DBSource.class).name();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (sourceName != null) {
            DynamicDataSource.setDataSource(sourceName);
        }
    }

    @Pointcut("execution(* com.hikcreate.update_hbase.dao..*.*(..))")
    public void pointCut() {
    }

    @After("pointCut()")
    public void after(JoinPoint point) {
        DynamicDataSource.clearDataSource();
    }
}
