package com.hikcreate.update_hbase.controller;

import com.hikcreate.update_hbase.Repo.SurveilEs;
import com.hikcreate.update_hbase.Repo.ViolationEs;
import com.hikcreate.update_hbase.entity.Surveil;
import com.hikcreate.update_hbase.entity.Violation;
import com.hikcreate.update_hbase.entity.test.PlateNumHis;
import com.hikcreate.update_hbase.entity.test.ViolationRes;
import com.hikcreate.update_hbase.utils.DateUtil;
import com.hikcreate.update_hbase.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.kafka.common.protocol.types.Field;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.*;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.*;

@RestController
@RequestMapping("/test")
public class TestController {

    @Autowired
    private TransportClient transportClient;
    @Autowired
    private ViolationEs violationEs;

    @Autowired
    private SurveilEs surveilEs;

    private  String JDBC_DRIVER = "org.apache.hive.jdbc.HiveDriver";


    @GetMapping("/findyuyuechuxing")
    public void findyuyuechuxing(@Param("len") Integer len){
        java.sql.Connection connection = null;
        try{
            Class.forName(JDBC_DRIVER);
            connection = DriverManager.getConnection("jdbc:hive2://172.16.25.25:10000/kakou",
                    "hdfs","hdfs");
            Statement stmt = connection.createStatement();
            int position=0;
            String[] bufstring=new String[5000];
            //打开带读取的文件
            BufferedReader br = new BufferedReader(new FileReader("/home/yuyechuxing/in.txt"));
            String line=null;
            while((line=br.readLine())!=null) {
                bufstring[position]=line;
                position++;
            }
            br.close();//关闭文件
            HashMap<String, String> carMap = new HashMap<>();
            for(int i=0;i<position;i++) {
                System.out.println(bufstring[i]);
                String[] split = bufstring[i].split("\t");
                String substring="";
                if(carMap.containsKey(split[0])){
                    String s = carMap.get(split[0]);
                    substring = s.substring(0, s.length() - 1);
                    substring=substring+",'"+split[2]+"')";
                }else {
                    substring="('"+split[2]+"')";
                }
                carMap.put(split[0],substring);
            }
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            File file = new File("/home/yuyechuxing/out.txt");
            if (!file.exists()) {
                boolean hasFile = file.createNewFile();
                fos = new FileOutputStream(file);
            }else {
                fos = new FileOutputStream(file, true);
            }
            for(Map.Entry<String,String> entry:carMap.entrySet()){
                String sql="select plate_num,plate_type,dev_code,watch_time,location_desc from kakou.car_flow where " +
                        "plate_num='"+entry.getKey()+"' and substr(watch_time,0,10) in "+entry.getValue()+" and day>'2020-03-10' " +
                        "and dev_code in ('5201000009150200010','5201000009150200015')";
                ResultSet resultSet=null;
                try {
                    resultSet = stmt.executeQuery(sql);
                }catch (Exception e){
                    e.printStackTrace();
                }
                while (resultSet.next()){
                    System.out.println("---------------------------");
                    osw = new OutputStreamWriter(fos, "utf-8");
                    osw.write(resultSet.getString(1)+"\t"+resultSet.getString(2)+"\t"+
                            resultSet.getString(3)+"\t"+resultSet.getString(4)+"\t"+
                            resultSet.getString(5)+"\r\n");
                    osw.flush();
                }
            }
            fos.close();
            osw.close();
        }catch (Exception e){
            e.printStackTrace();
        }
    }



    @GetMapping("/findHphmByXh")
    public List<ViolationRes> findHphmByXh(@RequestParam("xh")  String xh){
        List<ViolationRes> violationResList=new ArrayList<>();
        List<PlateNumHis> plateNumHisList=new ArrayList<>();
        try {
            BoolQueryBuilder rootQuery = QueryBuilders.boolQuery();
            rootQuery.must(QueryBuilders.termQuery("xh.keyword", xh));
            AggregationBuilder groupTerms = AggregationBuilders.terms("groupCode").field("hphm.keyword").size(Integer.MAX_VALUE).
                    subAggregation(AggregationBuilders.terms("hpzl").field("hpzl.keyword").size(Integer.MAX_VALUE).
                            subAggregation(AggregationBuilders.min("bjrq").field("bjrq")));
            SearchResponse response = transportClient.prepareSearch("veh_flow").setTypes("_doc").setQuery(rootQuery).addAggregation(groupTerms).
                    setExplain(true).execute().actionGet();
            Terms groupCode = response.getAggregations().get("groupCode");
            Map<Date,PlateNumHis> plateNumMap=new TreeMap<>();
            plateNumMap =  ((TreeMap)plateNumMap).descendingMap();
            for (Terms.Bucket codeBucket : groupCode.getBuckets()) {
                PlateNumHis plateNumHis = new PlateNumHis();
                Terms hpzl = codeBucket.getAggregations().get("hpzl");
                List<? extends Terms.Bucket> buckets = hpzl.getBuckets();
                String plateType = hpzl.getBuckets().get(0).getKeyAsString();
                Terms.Bucket bucket = hpzl.getBuckets().get(0);
                Min groupDate = bucket.getAggregations().get("bjrq");
                plateNumHis.setPlateNum(codeBucket.getKeyAsString());
                plateNumHis.setPlateType(plateType);
                plateNumHis.setStartDate(Utils.string2DateTime2(groupDate.getValueAsString()));
                plateNumMap.put(Utils.string2DateTime2(groupDate.getValueAsString()),plateNumHis);
            }
            Date endDate=new Date();
            for(Map.Entry<Date, PlateNumHis> entry : plateNumMap.entrySet()){
                PlateNumHis value = entry.getValue();
                value.setEndDate(endDate);
                plateNumHisList.add(value);
                endDate=value.getStartDate();
            }
            for(PlateNumHis plateNumHis:plateNumHisList){
                violationResList.addAll(getByPlateNumAndType1("贵"+plateNumHis.getPlateNum(),
                        plateNumHis.getPlateType(),plateNumHis.getStartDate(),plateNumHis.getEndDate()));
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            return violationResList;
        }
    }


    public List<ViolationRes> getByPlateNumAndType1(String plateNum,String plateType,Date startDate,Date endDate) {
        if (StringUtils.isEmpty(plateNum) || StringUtils.isEmpty(plateType)) {
            return null;
        }
        System.out.println(plateNum+"============"+plateType+"==================="
                +DateUtil.formatDateTime(startDate)+"=================="+DateUtil.formatDateTime(endDate));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must(QueryBuilders.termQuery("hphm.keyword", plateNum));
        queryBuilder.must(QueryBuilders.termQuery("hpzl.keyword", plateType));
        queryBuilder.mustNot(QueryBuilders.matchQuery("type.keyword", "del"));
        queryBuilder.must(QueryBuilders.rangeQuery("wfsj.keyword").gt(DateUtil.formatDateTime(startDate)).
                lt(DateUtil.formatDateTime(endDate)));
        SearchQuery searchQuery = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .withPageable(PageRequest.of((0), 100))
                .build();
        //查询
        Iterable<Violation> violationIterable = violationEs.search(searchQuery);
        Iterator<Violation> violationIterator = violationIterable.iterator();
        Map<String, Violation> violationMap = new HashMap<>();
        while (violationIterator.hasNext()){
            Violation violation = violationIterator.next();
            violationMap.put(violation.getWfsj() + "#" + violation.getWfxw() + "#" + violation.getWfdd(), violation);
        }
        System.out.println("现场："+violationMap.keySet());

        SearchQuery searchQuery1 = new NativeSearchQueryBuilder()
                .withQuery(queryBuilder)
                .withPageable(PageRequest.of((0), 100))
                .build();
        Iterable<Surveil> surveilSearch = surveilEs.search(searchQuery1);
        Iterator<Surveil> surveilIterator = surveilSearch.iterator();
        Map<String, Surveil> surveilMap = new HashMap<>();
        while (surveilIterator.hasNext()){
            Surveil surveil = surveilIterator.next();
            surveilMap.put(surveil.getWfsj() + "#" + surveil.getWfxw() + "#" + surveil.getWfdd(), surveil);
        }

        System.out.println("非现场："+surveilMap.keySet());

        //合并
        //violation>=surveil,或violation有surveil没有
        List<ViolationRes> violationResList = new ArrayList<>();
        for (Map.Entry<String, Violation> entry : violationMap.entrySet()) {
            if (surveilMap.containsKey(entry.getKey())) {
                if (entry.getValue().getGxsj().compareTo(surveilMap.get(entry.getKey()).getGxsj()) > 0 ||
                        entry.getValue().getGxsj().compareTo(surveilMap.get(entry.getKey()).getGxsj()) == 0) {
                    ViolationRes violationRes = new ViolationRes();
                    BeanUtils.copyProperties(surveilMap.get(entry.getKey()), violationRes);
                    BeanUtils.copyProperties(entry.getValue(), violationRes);
                    violationRes.setId(entry.getValue().getWfbh() + "-" + entry.getValue().getType());
                    violationResList.add(violationRes);
                }
            } else {
                ViolationRes violationRes = new ViolationRes();
                BeanUtils.copyProperties(entry.getValue(), violationRes);
                violationRes.setId(entry.getValue().getWfbh() + "-" + entry.getValue().getType());
                violationResList.add(violationRes);
            }
        }
        //violation<surveil,或surveil有violation没有
        surveilMap.forEach((key, value) -> {
            if (violationMap.containsKey(key)) {
                if (value.getGxsj().compareTo(violationMap.get(key).getGxsj()) > 0) {
                    ViolationRes violationRes = new ViolationRes();
                    BeanUtils.copyProperties(violationMap.get(key), violationRes);
                    BeanUtils.copyProperties(value, violationRes);
                    violationRes.setId(value.getXh() + "-" + value.getType());
                    violationResList.add(violationRes);
                }
            } else {
                ViolationRes violationRes = new ViolationRes();
                BeanUtils.copyProperties(value, violationRes);
                violationRes.setId(value.getXh() + "-" + value.getType());
                violationResList.add(violationRes);
            }
        });
        return violationResList;
    }

}
