package com.hikcreate.update_hbase.controller;

import com.hikcreate.update_hbase.service.SurveilService;
import com.hikcreate.update_hbase.service.VehicleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/vehicle")
public class VehicleController {

    @Autowired
    private VehicleService vehicleService;

    @GetMapping("/getVehicle2Hbase")
    public void getVehicle2Hbase(@RequestParam("hphm") String hphm, @RequestParam("hpzl") String hpzl){
        vehicleService.getVehicle2Hbase(hphm,hpzl);
    }
    @RequestMapping("/insertVehicle2Es")
    public void insertVehicle2Es(@RequestParam("ids") String...  ids) {
        vehicleService.imDataOracle2EsById(ids);
    }

    @GetMapping("/getVmVehicle2Hbase")
    public void getVmVehicle2Hbase(@RequestParam("start") String start, @RequestParam("end") String end){
        vehicleService.getVmVehicle2Hbase(start,end);
    }

    /**
     * 同步实时表所有数据
     * @param day
     */
    @GetMapping("/getVehicle2HbaseAllRealTime")
    public void getVehicle2HbaseAllRealTime(@RequestParam("day") String day){
        vehicleService.getVehicle2HbaseAllRealTime(day);
    }


    @GetMapping("/delVehCheck")
    public ResponseEntity delVehCheck(){
        try {
            vehicleService.delVehCheck();
            return new ResponseEntity("ok", HttpStatus.OK);
        }catch (Exception e){
            return new ResponseEntity("failed", HttpStatus.OK);
        }
    }


    /**
     * 将veh_out表中
     * @return
     */
    @GetMapping("/vehEsOutMerge")
    public ResponseEntity vehEsOutMerge(){
        try {
            vehicleService.vehDay();
            return new ResponseEntity("ok", HttpStatus.OK);
        }catch (Exception e){
            e.printStackTrace();
            return new ResponseEntity("failed", HttpStatus.OK);
        }
    }


}
