package com.hikcreate.update_hbase.controller;

import com.hikcreate.update_hbase.entity.Violation;
import com.hikcreate.update_hbase.service.SurveilService;
import com.hikcreate.update_hbase.service.VioEsService;
import com.hikcreate.update_hbase.service.ViolationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/vio")
public class VioController {

    @Autowired
    private VioEsService vioEsService;
    @Autowired
    private ViolationService violationService;
    @Autowired
    private SurveilService surveilService;
    @Value("${thread.num}")
    private int threadNum;




    @GetMapping("/insert2es12")
    public void getHisVioToEs(@RequestParam("start") String start,@RequestParam("end") String end,@RequestParam("table") String table){
        vioEsService.getHisVioToEsByTable(start,end,table);
    }

    @GetMapping("/insert2es")
    public void getHisVioToEsByHphm(@RequestParam("start") String start,@RequestParam("end") String end,@RequestParam("table") String table,
                              @RequestParam("hphm") String hphm){
        vioEsService.getHisVioToEsByHphm(start,end,table,hphm);
    }


    @GetMapping("/vioDelHisRange")
    public ResponseEntity vioDelHisRange(@RequestParam("start") String start, @RequestParam("end") String end, @RequestParam("table") String table){
        vioEsService.vioDelHisRange(start,end,table);
        return new ResponseEntity("complete", HttpStatus.OK);
    }


    @GetMapping("/testVioDay")
    public ResponseEntity testVioDay(){
        long s = System.currentTimeMillis();
        for(int i=0;i<threadNum;i++){
            int finalI = i;
            new Thread(() -> {vioEsService.toEsPastDay(finalI);}).start();
        }
        long e = System.currentTimeMillis();
        return new ResponseEntity(s+"------"+e, HttpStatus.OK);
    }


    @GetMapping("/delVio")
    public ResponseEntity delVio(){
        vioEsService.vioDelDay();
        return new ResponseEntity("---okok---", HttpStatus.OK);
    }

    /**
     * 同步小数据量表到Es的现场违法表：vio_violation,vm_vio_violation_del
     * @return
     */
    @GetMapping("/sysViolationSmallData")
    public ResponseEntity sysViolationSmallData(){
        violationService.sysViolationSmallData();
        return new ResponseEntity("---okok---", HttpStatus.OK);
    }

    /**
     * 同步小数据量表到Es的非现场违法表：vio_surveil,vm_vio_surveil_del
     * @return
     */
    @GetMapping("/sysSurSmallData")
    public ResponseEntity sysSurSmallData(){
        surveilService.sysSurSmallData();
        return new ResponseEntity("---okok---", HttpStatus.OK);
    }



}
